/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly.connector;

import com.google.common.util.concurrent.SettableFuture;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientException;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.RequestWriter;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.util.PropertiesHelper;

public class GrizzlyConnector
extends RequestWriter
implements Connector {
    private AsyncHttpClient client;

    public GrizzlyConnector(Configuration configuration) {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        if (configuration != null) {
            Object threadPoolSize = configuration.getProperties().get("jersey.config.client.async.threadPoolSize");
            ExecutorService executorService = threadPoolSize != null && threadPoolSize instanceof Integer && (Integer)threadPoolSize > 0 ? Executors.newFixedThreadPool((Integer)threadPoolSize) : Executors.newCachedThreadPool();
            builder = builder.setExecutorService(executorService);
            builder.setConnectionTimeoutInMs(((Integer)PropertiesHelper.getValue((Map)configuration.getProperties(), (String)"jersey.config.client.connectTimeout", (Object)0)).intValue());
            builder.setRequestTimeoutInMs(((Integer)PropertiesHelper.getValue((Map)configuration.getProperties(), (String)"jersey.config.client.readTimeout", (Object)0)).intValue());
        } else {
            ExecutorService executorService = Executors.newCachedThreadPool();
            builder.setExecutorService(executorService);
        }
        AsyncHttpClientConfig config = builder.setAllowPoolingConnection(true).build();
        this.client = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
    }

    public ClientResponse apply(ClientRequest requestContext) {
        Response connectorResponse;
        try {
            Request connectorRequest = this.translate(requestContext);
            ListenableFuture respFuture = this.client.executeRequest(connectorRequest);
            connectorResponse = (Response)respFuture.get();
        }
        catch (ExecutionException ex) {
            Throwable e = ex.getCause() == null ? ex : ex.getCause();
            throw new ClientException(e.getMessage(), e);
        }
        catch (InterruptedException ex) {
            throw new ClientException(ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ClientException(ex.getMessage(), (Throwable)ex);
        }
        return this.translate(requestContext, connectorResponse);
    }

    public Future<?> apply(final ClientRequest request, final AsyncConnectorCallback callback) {
        Throwable failure;
        Request connectorRequest = this.translate(request);
        try {
            return this.client.executeRequest(connectorRequest, (AsyncHandler)new AsyncCompletionHandler<ClientResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public ClientResponse onCompleted(Response connectorResponse) throws Exception {
                    ClientResponse response = GrizzlyConnector.this.translate(request, connectorResponse);
                    try {
                        ClientResponse clientResponse = response;
                        return clientResponse;
                    }
                    finally {
                        callback.response(response);
                    }
                }

                public void onThrowable(Throwable t) {
                    t = t instanceof IOException ? new ClientException(t.getMessage(), t) : t;
                    callback.failure(t);
                }
            });
        }
        catch (IOException ex) {
            failure = ex;
            callback.failure((Throwable)new ClientException(ex.getMessage(), ex.getCause()));
        }
        catch (Throwable t) {
            failure = t;
            callback.failure(t);
        }
        SettableFuture errorFuture = SettableFuture.create();
        errorFuture.setException(failure);
        return errorFuture;
    }

    public void close() {
        this.client.close();
    }

    private ClientResponse translate(ClientRequest requestContext, final Response original) {
        ClientResponse responseContext = new ClientResponse(new Response.StatusType(){

            public int getStatusCode() {
                return original.getStatusCode();
            }

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)original.getStatusCode());
            }

            public String getReasonPhrase() {
                return original.getStatusText();
            }
        }, requestContext);
        for (Map.Entry entry : original.getHeaders().entrySet()) {
            for (String value : (List)entry.getValue()) {
                responseContext.getHeaders().add(entry.getKey(), (Object)value);
            }
        }
        try {
            responseContext.setEntityStream(original.getResponseBodyAsStream());
        }
        catch (IOException e) {
            Logger.getLogger(GrizzlyConnector.class.getName()).log(Level.SEVERE, null, e);
        }
        return responseContext;
    }

    private Request translate(ClientRequest requestContext) {
        String strMethod = requestContext.getMethod();
        URI uri = requestContext.getUri();
        RequestBuilder builder = new RequestBuilder(strMethod).setUrl(uri.toString());
        builder.setFollowRedirects(((Boolean)PropertiesHelper.getValue((Map)requestContext.getConfiguration().getProperties(), (String)"jersey.config.client.followRedirects", (Object)true)).booleanValue());
        Request.EntityWriter entity = this.getHttpEntity(requestContext);
        if (entity != null) {
            builder = builder.setBody(entity);
        }
        Request result = builder.build();
        GrizzlyConnector.writeOutBoundHeaders((MultivaluedMap<String, Object>)requestContext.getHeaders(), result);
        return result;
    }

    private static void writeOutBoundHeaders(MultivaluedMap<String, Object> headers, Request request) {
        for (Map.Entry e : headers.entrySet()) {
            List vs = (List)e.getValue();
            if (vs.size() == 1) {
                request.getHeaders().add((String)e.getKey(), new String[]{vs.get(0).toString()});
                continue;
            }
            StringBuilder b = new StringBuilder();
            for (Object v : (List)e.getValue()) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(v);
            }
            request.getHeaders().add((String)e.getKey(), new String[]{b.toString()});
        }
    }

    private Request.EntityWriter getHttpEntity(ClientRequest requestContext) {
        Object entity = requestContext.getEntity();
        if (entity == null) {
            return null;
        }
        final RequestWriter.RequestEntityWriter rew = this.getRequestEntityWriter(requestContext);
        return new Request.EntityWriter(){

            public void writeEntity(OutputStream out) throws IOException {
                rew.writeRequestEntity(out);
            }
        };
    }

    public String getName() {
        return "Grizzly Http Client";
    }
}

