
package org.glassfish.jersey.grizzly.connector;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "org.glassfish.jersey.grizzly.connector.localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableEXPECTED_CONNECTOR_PROVIDER_NOT_USED() {
        return MESSAGE_FACTORY.getMessage("expected.connector.provider.not.used");
    }

    /**
     * The supplied component is not configured to use a GrizzlyConnectorProvider.
     * 
     */
    public static String EXPECTED_CONNECTOR_PROVIDER_NOT_USED() {
        return LOCALIZER.localize(localizableEXPECTED_CONNECTOR_PROVIDER_NOT_USED());
    }

    public static Localizable localizableERROR_BUFFERING_ENTITY() {
        return MESSAGE_FACTORY.getMessage("error.buffering.entity");
    }

    /**
     * Error buffering the entity.
     * 
     */
    public static String ERROR_BUFFERING_ENTITY() {
        return LOCALIZER.localize(localizableERROR_BUFFERING_ENTITY());
    }

    public static Localizable localizableINVALID_CONFIGURABLE_COMPONENT_TYPE(Object arg0) {
        return MESSAGE_FACTORY.getMessage("invalid.configurable.component.type", arg0);
    }

    /**
     * The supplied component "{0}" is not assignable from JerseyClient or JerseyWebTarget.
     * 
     */
    public static String INVALID_CONFIGURABLE_COMPONENT_TYPE(Object arg0) {
        return LOCALIZER.localize(localizableINVALID_CONFIGURABLE_COMPONENT_TYPE(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
