/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly.connector;

import com.google.common.util.concurrent.SettableFuture;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.Version;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.collection.ByteBufferInputStream;
import org.glassfish.jersey.internal.util.collection.NonBlockingInputStream;
import org.glassfish.jersey.message.internal.OutboundMessageContext;

public class GrizzlyConnector
implements Connector {
    private volatile AsyncHttpClient grizzlyClient = null;
    private final Configuration config;
    private final Object LOCK = new Object();

    public GrizzlyConnector(Configuration config) {
        this.config = config;
    }

    public ClientResponse apply(final ClientRequest request) {
        AsyncHttpClient grizzlyClient = this.getClient(request);
        Request connectorRequest = this.translate(request);
        final SettableFuture responseFuture = SettableFuture.create();
        final ByteBufferInputStream entityStream = new ByteBufferInputStream();
        final AtomicBoolean futureSet = new AtomicBoolean(false);
        try {
            grizzlyClient.executeRequest(connectorRequest, (AsyncHandler)new AsyncHandler<Void>(){
                private volatile HttpResponseStatus status = null;

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    this.status = responseStatus;
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                    if (!futureSet.compareAndSet(false, true)) {
                        return AsyncHandler.STATE.ABORT;
                    }
                    responseFuture.set((Object)GrizzlyConnector.this.translate(request, this.status, headers, (NonBlockingInputStream)entityStream));
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    entityStream.put(bodyPart.getBodyByteBuffer());
                    return AsyncHandler.STATE.CONTINUE;
                }

                public Void onCompleted() throws Exception {
                    entityStream.closeQueue();
                    return null;
                }

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                    entityStream.closeQueue(t);
                    if (futureSet.compareAndSet(false, true)) {
                        t = t instanceof IOException ? new ProcessingException(t.getMessage(), t) : t;
                        responseFuture.setException(t);
                    }
                }
            });
            return (ClientResponse)responseFuture.get();
        }
        catch (IOException ex) {
            throw new ProcessingException(ex.getMessage(), ex.getCause());
        }
        catch (ExecutionException ex) {
            Throwable e = ex.getCause() == null ? ex : ex.getCause();
            throw new ProcessingException(e.getMessage(), e);
        }
        catch (InterruptedException ex) {
            throw new ProcessingException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncHttpClient getClient(ClientRequest request) {
        JerseyClient jerseyClient = request.getClient();
        AsyncHttpClient client = this.grizzlyClient;
        if (client == null) {
            Object object = this.LOCK;
            synchronized (object) {
                client = this.grizzlyClient;
                if (client == null) {
                    this.grizzlyClient = client = this.createClient((Client)jerseyClient);
                }
            }
        }
        return client;
    }

    private AsyncHttpClient createClient(Client client) {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        if (this.config != null) {
            Object threadPoolSize = this.config.getProperties().get("jersey.config.client.async.threadPoolSize");
            ExecutorService executorService = threadPoolSize != null && threadPoolSize instanceof Integer && (Integer)threadPoolSize > 0 ? Executors.newFixedThreadPool((Integer)threadPoolSize) : Executors.newCachedThreadPool();
            builder = builder.setExecutorService(executorService);
            builder.setConnectionTimeoutInMs(((Integer)PropertiesHelper.getValue((Map)this.config.getProperties(), (String)"jersey.config.client.connectTimeout", (Object)0)).intValue());
            builder.setRequestTimeoutInMs(((Integer)PropertiesHelper.getValue((Map)this.config.getProperties(), (String)"jersey.config.client.readTimeout", (Object)0)).intValue());
        } else {
            ExecutorService executorService = Executors.newCachedThreadPool();
            builder.setExecutorService(executorService);
        }
        builder.setAllowPoolingConnection(true);
        if (client.getSslContext() != null) {
            builder.setSSLContext(client.getSslContext());
        }
        if (client.getHostnameVerifier() != null) {
            builder.setHostnameVerifier(client.getHostnameVerifier());
        }
        AsyncHttpClientConfig asyncClientConfig = builder.build();
        return new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(asyncClientConfig), asyncClientConfig);
    }

    public Future<?> apply(final ClientRequest request, final AsyncConnectorCallback callback) {
        Throwable failure;
        Request connectorRequest = this.translate(request);
        final ByteBufferInputStream entityStream = new ByteBufferInputStream();
        final AtomicBoolean callbackInvoked = new AtomicBoolean(false);
        try {
            return this.getClient(request).executeRequest(connectorRequest, (AsyncHandler)new AsyncHandler<Void>(){
                private volatile HttpResponseStatus status = null;

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    this.status = responseStatus;
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                    if (!callbackInvoked.compareAndSet(false, true)) {
                        return AsyncHandler.STATE.ABORT;
                    }
                    callback.response(GrizzlyConnector.this.translate(request, this.status, headers, (NonBlockingInputStream)entityStream));
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    entityStream.put(bodyPart.getBodyByteBuffer());
                    return AsyncHandler.STATE.CONTINUE;
                }

                public Void onCompleted() throws Exception {
                    entityStream.closeQueue();
                    return null;
                }

                public void onThrowable(Throwable t) {
                    entityStream.closeQueue(t);
                    if (callbackInvoked.compareAndSet(false, true)) {
                        t = t instanceof IOException ? new ProcessingException(t.getMessage(), t) : t;
                        callback.failure(t);
                    }
                }
            });
        }
        catch (IOException ex) {
            failure = new ProcessingException(ex.getMessage(), ex.getCause());
        }
        catch (Throwable t) {
            failure = t;
        }
        if (callbackInvoked.compareAndSet(false, true)) {
            callback.failure(failure);
        }
        SettableFuture errorFuture = SettableFuture.create();
        errorFuture.setException(failure);
        return errorFuture;
    }

    public void close() {
        if (this.grizzlyClient != null) {
            this.grizzlyClient.close();
        }
    }

    private ClientResponse translate(ClientRequest requestContext, final HttpResponseStatus status, HttpResponseHeaders headers, NonBlockingInputStream entityStream) {
        ClientResponse responseContext = new ClientResponse(new Response.StatusType(){

            public int getStatusCode() {
                return status.getStatusCode();
            }

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)status.getStatusCode());
            }

            public String getReasonPhrase() {
                return status.getStatusText();
            }
        }, requestContext);
        for (Map.Entry entry : headers.getHeaders().entrySet()) {
            for (String value : (List)entry.getValue()) {
                responseContext.getHeaders().add(entry.getKey(), (Object)value);
            }
        }
        responseContext.setEntityStream((InputStream)entityStream);
        return responseContext;
    }

    private Request translate(ClientRequest requestContext) {
        String strMethod = requestContext.getMethod();
        URI uri = requestContext.getUri();
        RequestBuilder builder = new RequestBuilder(strMethod).setUrl(uri.toString());
        builder.setFollowRedirects(((Boolean)requestContext.resolveProperty("jersey.config.client.followRedirects", (Object)true)).booleanValue());
        Request.EntityWriter entity = this.getHttpEntity(requestContext);
        if (entity != null) {
            builder = builder.setBody(entity);
        }
        Request result = builder.build();
        GrizzlyConnector.writeOutBoundHeaders((MultivaluedMap<String, Object>)requestContext.getHeaders(), result);
        return result;
    }

    private static void writeOutBoundHeaders(MultivaluedMap<String, Object> headers, Request request) {
        for (Map.Entry e : headers.entrySet()) {
            List vs = (List)e.getValue();
            if (vs.size() == 1) {
                request.getHeaders().add((String)e.getKey(), new String[]{vs.get(0).toString()});
                continue;
            }
            StringBuilder b = new StringBuilder();
            for (Object v : (List)e.getValue()) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(v);
            }
            request.getHeaders().add((String)e.getKey(), new String[]{b.toString()});
        }
    }

    private Request.EntityWriter getHttpEntity(final ClientRequest requestContext) {
        Object entity = requestContext.getEntity();
        if (entity == null) {
            return null;
        }
        return new Request.EntityWriter(){

            public void writeEntity(final OutputStream out) throws IOException {
                requestContext.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                    public OutputStream getOutputStream(int contentLength) throws IOException {
                        return out;
                    }
                });
                requestContext.writeEntity();
            }
        };
    }

    public String getName() {
        return String.format("Async HTTP Grizzly Connector %s", Version.getVersion());
    }
}

