
package org.glassfish.jersey.grizzly.connector;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.grizzly.connector.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableERROR_BUFFERING_ENTITY() {
        return messageFactory.getMessage("error.buffering.entity");
    }

    /**
     * Error buffering the entity.
     * 
     */
    public static String ERROR_BUFFERING_ENTITY() {
        return localizer.localize(localizableERROR_BUFFERING_ENTITY());
    }

}
