/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly.connector;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import jersey.repackaged.com.google.common.util.concurrent.SettableFuture;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.grizzly.connector.LocalizationMessages;
import org.glassfish.jersey.internal.Version;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.collection.ByteBufferInputStream;
import org.glassfish.jersey.internal.util.collection.NonBlockingInputStream;
import org.glassfish.jersey.message.internal.HeaderUtils;
import org.glassfish.jersey.message.internal.OutboundMessageContext;

class GrizzlyConnector
implements Connector {
    private final AsyncHttpClient grizzlyClient;

    GrizzlyConnector(Client client, Configuration config) {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        if (config != null) {
            Object threadPoolSize = config.getProperties().get("jersey.config.client.async.threadPoolSize");
            ExecutorService executorService = threadPoolSize != null && threadPoolSize instanceof Integer && (Integer)threadPoolSize > 0 ? Executors.newFixedThreadPool((Integer)threadPoolSize) : Executors.newCachedThreadPool();
            builder = builder.setExecutorService(executorService);
            builder.setConnectionTimeoutInMs(((Integer)PropertiesHelper.getValue((Map)config.getProperties(), (String)"jersey.config.client.connectTimeout", (Object)0)).intValue());
            builder.setRequestTimeoutInMs(((Integer)PropertiesHelper.getValue((Map)config.getProperties(), (String)"jersey.config.client.readTimeout", (Object)0)).intValue());
        } else {
            ExecutorService executorService = Executors.newCachedThreadPool();
            builder.setExecutorService(executorService);
        }
        builder.setAllowPoolingConnection(true);
        if (client.getSslContext() != null) {
            builder.setSSLContext(client.getSslContext());
        }
        if (client.getHostnameVerifier() != null) {
            builder.setHostnameVerifier(client.getHostnameVerifier());
        }
        AsyncHttpClientConfig asyncClientConfig = builder.build();
        this.grizzlyClient = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(asyncClientConfig), asyncClientConfig);
    }

    public ClientResponse apply(final ClientRequest request) {
        Request connectorRequest = this.translate(request);
        final Map<String, String> clientHeadersSnapshot = GrizzlyConnector.writeOutBoundHeaders((MultivaluedMap<String, Object>)request.getHeaders(), connectorRequest);
        final SettableFuture responseFuture = SettableFuture.create();
        final ByteBufferInputStream entityStream = new ByteBufferInputStream();
        final AtomicBoolean futureSet = new AtomicBoolean(false);
        try {
            this.grizzlyClient.executeRequest(connectorRequest, (AsyncHandler)new AsyncHandler<Void>(){
                private volatile HttpResponseStatus status = null;

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    this.status = responseStatus;
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                    if (!futureSet.compareAndSet(false, true)) {
                        return AsyncHandler.STATE.ABORT;
                    }
                    HeaderUtils.checkHeaderChanges((Map)clientHeadersSnapshot, (MultivaluedMap)request.getHeaders(), (String)GrizzlyConnector.this.getClass().getName());
                    responseFuture.set((Object)GrizzlyConnector.this.translate(request, this.status, headers, (NonBlockingInputStream)entityStream));
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    entityStream.put(bodyPart.getBodyByteBuffer());
                    return AsyncHandler.STATE.CONTINUE;
                }

                public Void onCompleted() throws Exception {
                    entityStream.closeQueue();
                    return null;
                }

                public void onThrowable(Throwable t) {
                    entityStream.closeQueue(t);
                    if (futureSet.compareAndSet(false, true)) {
                        t = t instanceof IOException ? new ProcessingException(t.getMessage(), t) : t;
                        responseFuture.setException(t);
                    }
                }
            });
            return (ClientResponse)responseFuture.get();
        }
        catch (IOException ex) {
            throw new ProcessingException(ex.getMessage(), ex.getCause());
        }
        catch (ExecutionException ex) {
            Throwable e = ex.getCause() == null ? ex : ex.getCause();
            throw new ProcessingException(e.getMessage(), e);
        }
        catch (InterruptedException ex) {
            throw new ProcessingException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Future<?> apply(final ClientRequest request, final AsyncConnectorCallback callback) {
        Throwable failure;
        Request connectorRequest = this.translate(request);
        final Map<String, String> clientHeadersSnapshot = GrizzlyConnector.writeOutBoundHeaders((MultivaluedMap<String, Object>)request.getHeaders(), connectorRequest);
        final ByteBufferInputStream entityStream = new ByteBufferInputStream();
        final AtomicBoolean callbackInvoked = new AtomicBoolean(false);
        try {
            return this.grizzlyClient.executeRequest(connectorRequest, (AsyncHandler)new AsyncHandler<Void>(){
                private volatile HttpResponseStatus status = null;

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    this.status = responseStatus;
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                    if (!callbackInvoked.compareAndSet(false, true)) {
                        return AsyncHandler.STATE.ABORT;
                    }
                    HeaderUtils.checkHeaderChanges((Map)clientHeadersSnapshot, (MultivaluedMap)request.getHeaders(), (String)GrizzlyConnector.this.getClass().getName());
                    callback.response(GrizzlyConnector.this.translate(request, this.status, headers, (NonBlockingInputStream)entityStream));
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    entityStream.put(bodyPart.getBodyByteBuffer());
                    return AsyncHandler.STATE.CONTINUE;
                }

                public Void onCompleted() throws Exception {
                    entityStream.closeQueue();
                    return null;
                }

                public void onThrowable(Throwable t) {
                    entityStream.closeQueue(t);
                    if (callbackInvoked.compareAndSet(false, true)) {
                        t = t instanceof IOException ? new ProcessingException(t.getMessage(), t) : t;
                        callback.failure(t);
                    }
                }
            });
        }
        catch (IOException ex) {
            failure = new ProcessingException(ex.getMessage(), ex.getCause());
        }
        catch (Throwable t) {
            failure = t;
        }
        if (callbackInvoked.compareAndSet(false, true)) {
            callback.failure(failure);
        }
        SettableFuture errorFuture = SettableFuture.create();
        errorFuture.setException(failure);
        return errorFuture;
    }

    public void close() {
        this.grizzlyClient.close();
    }

    private ClientResponse translate(ClientRequest requestContext, final HttpResponseStatus status, HttpResponseHeaders headers, NonBlockingInputStream entityStream) {
        ClientResponse responseContext = new ClientResponse(new Response.StatusType(){

            public int getStatusCode() {
                return status.getStatusCode();
            }

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)status.getStatusCode());
            }

            public String getReasonPhrase() {
                return status.getStatusText();
            }
        }, requestContext);
        for (Map.Entry entry : headers.getHeaders().entrySet()) {
            for (String value : (List)entry.getValue()) {
                responseContext.getHeaders().add(entry.getKey(), (Object)value);
            }
        }
        responseContext.setEntityStream((InputStream)entityStream);
        return responseContext;
    }

    private Request translate(ClientRequest requestContext) {
        String strMethod = requestContext.getMethod();
        URI uri = requestContext.getUri();
        RequestBuilder builder = new RequestBuilder(strMethod).setUrl(uri.toString());
        builder.setFollowRedirects(((Boolean)requestContext.resolveProperty("jersey.config.client.followRedirects", (Object)true)).booleanValue());
        if (requestContext.hasEntity()) {
            Boolean enableBuffering = requestContext.resolveProperty("jersey.config.client.request.entity.processing", RequestEntityProcessing.class) == RequestEntityProcessing.BUFFERED;
            if (enableBuffering.booleanValue()) {
                byte[] entityBytes = this.bufferEntity(requestContext);
                builder = builder.setBody(entityBytes);
            } else {
                builder.setBody(this.getEntityWriter(requestContext));
            }
        }
        return builder.build();
    }

    private byte[] bufferEntity(ClientRequest requestContext) {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        requestContext.setStreamProvider(new OutboundMessageContext.StreamProvider(){

            public OutputStream getOutputStream(int contentLength) throws IOException {
                return baos;
            }
        });
        try {
            requestContext.writeEntity();
        }
        catch (IOException e) {
            throw new ProcessingException(LocalizationMessages.ERROR_BUFFERING_ENTITY(), (Throwable)e);
        }
        return baos.toByteArray();
    }

    private static Map<String, String> writeOutBoundHeaders(MultivaluedMap<String, Object> headers, Request request) {
        Map stringHeaders = HeaderUtils.asStringHeadersSingleValue(headers);
        for (Map.Entry e : stringHeaders.entrySet()) {
            request.getHeaders().add((String)e.getKey(), new String[]{(String)e.getValue()});
        }
        return stringHeaders;
    }

    private Request.EntityWriter getEntityWriter(final ClientRequest requestContext) {
        return new Request.EntityWriter(){

            public void writeEntity(final OutputStream out) throws IOException {
                requestContext.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                    public OutputStream getOutputStream(int contentLength) throws IOException {
                        return out;
                    }
                });
                requestContext.writeEntity();
            }
        };
    }

    public String getName() {
        return String.format("Async HTTP Grizzly Connector %s", Version.getVersion());
    }
}

