
package org.glassfish.jersey.grizzly.connector;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.grizzly.connector.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableEXPECTED_CONNECTOR_PROVIDER_NOT_USED() {
        return messageFactory.getMessage("expected.connector.provider.not.used");
    }

    /**
     * The supplied component is not configured to use a GrizzlyConnectorProvider.
     * 
     */
    public static String EXPECTED_CONNECTOR_PROVIDER_NOT_USED() {
        return localizer.localize(localizableEXPECTED_CONNECTOR_PROVIDER_NOT_USED());
    }

    public static Localizable localizableERROR_BUFFERING_ENTITY() {
        return messageFactory.getMessage("error.buffering.entity");
    }

    /**
     * Error buffering the entity.
     * 
     */
    public static String ERROR_BUFFERING_ENTITY() {
        return localizer.localize(localizableERROR_BUFFERING_ENTITY());
    }

    public static Localizable localizableINVALID_CONFIGURABLE_COMPONENT_TYPE(Object arg0) {
        return messageFactory.getMessage("invalid.configurable.component.type", arg0);
    }

    /**
     * The supplied component "{0}" is not assignable from JerseyClient or JerseyWebTarget.
     * 
     */
    public static String INVALID_CONFIGURABLE_COMPONENT_TYPE(Object arg0) {
        return localizer.localize(localizableINVALID_CONFIGURABLE_COMPONENT_TYPE(arg0));
    }

}
