
package org.glassfish.jersey.helidon.connector;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "org.glassfish.jersey.helidon.connector.localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableNOT_HELIDON_CONFIG(Object arg0) {
        return MESSAGE_FACTORY.getMessage("not.helidon.config", arg0);
    }

    /**
     * Given instance {0} is not Helidon config. Provided HelidonProperties.CONFIG is ignored.
     * 
     */
    public static String NOT_HELIDON_CONFIG(Object arg0) {
        return LOCALIZER.localize(localizableNOT_HELIDON_CONFIG(arg0));
    }

    public static Localizable localizableWRONG_PROXY_URI_TYPE(Object arg0) {
        return MESSAGE_FACTORY.getMessage("wrong.proxy.uri.type", arg0);
    }

    /**
     * The proxy URI ("{0}") property MUST be an instance of String or URI.
     * 
     */
    public static String WRONG_PROXY_URI_TYPE(Object arg0) {
        return LOCALIZER.localize(localizableWRONG_PROXY_URI_TYPE(arg0));
    }

    public static Localizable localizableNOT_SUPPORTED() {
        return MESSAGE_FACTORY.getMessage("not.supported");
    }

    /**
     * Helidon connector is not supported on JDK version < 11.
     * 
     */
    public static String NOT_SUPPORTED() {
        return LOCALIZER.localize(localizableNOT_SUPPORTED());
    }

    public static Localizable localizableUNSUPPORTED_PROXY_SCHEMA(Object arg0) {
        return MESSAGE_FACTORY.getMessage("unsupported.proxy.schema", arg0);
    }

    /**
     * Proxy schema "{0}" not supported.
     * 
     */
    public static String UNSUPPORTED_PROXY_SCHEMA(Object arg0) {
        return LOCALIZER.localize(localizableUNSUPPORTED_PROXY_SCHEMA(arg0));
    }

    public static Localizable localizableERROR_WRITING_ENTITY(Object arg0) {
        return MESSAGE_FACTORY.getMessage("error.writing.entity", arg0);
    }

    /**
     * Error writing entity: {0}.
     * 
     */
    public static String ERROR_WRITING_ENTITY(Object arg0) {
        return LOCALIZER.localize(localizableERROR_WRITING_ENTITY(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
