/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.helidon.connector;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.OutputStreamPublisher;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ByteChannelBodyWriter;
import io.helidon.media.common.ContentWriters;
import io.helidon.media.common.MessageBodyContext;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.WebClientResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.function.Function;
import javax.ws.rs.ProcessingException;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.helidon.connector.LocalizationMessages;
import org.glassfish.jersey.helidon.connector.OutputStreamChannel;

class HelidonEntity {
    HelidonEntity() {
    }

    static Optional<MessageBodyWriter<?>> helidonWriter(HelidonEntityType type) {
        switch (type) {
            case BYTE_ARRAY_OUTPUT_STREAM: {
                return Optional.of(new OutputStreamBodyWriter());
            }
            case OUTPUT_STREAM_PUBLISHER: {
                return Optional.empty();
            }
            case READABLE_BYTE_CHANNEL: {
                return Optional.of(ByteChannelBodyWriter.create());
            }
        }
        return Optional.empty();
    }

    static CompletionStage<WebClientResponse> submit(HelidonEntityType type, ClientRequest requestContext, WebClientRequestBuilder requestBuilder, ExecutorService executorService) {
        CompletionStage stage = null;
        if (type != null) {
            int bufferSize = (Integer)requestContext.resolveProperty("jersey.config.client.contentLength.buffer", (Object)8192);
            switch (type) {
                case BYTE_ARRAY_OUTPUT_STREAM: {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(bufferSize);
                    requestContext.setStreamProvider(contentLength -> baos);
                    ((ProcessingRunnable)() -> requestContext.writeEntity()).run();
                    stage = requestBuilder.submit((Object)baos);
                    break;
                }
                case READABLE_BYTE_CHANNEL: {
                    OutputStreamChannel channel = new OutputStreamChannel(bufferSize);
                    requestContext.setStreamProvider(contentLength -> channel);
                    executorService.execute(() -> requestContext.writeEntity());
                    stage = requestBuilder.submit((Object)channel);
                    break;
                }
                case OUTPUT_STREAM_PUBLISHER: {
                    OutputStreamPublisher publisher = new OutputStreamPublisher();
                    requestContext.setStreamProvider(contentLength -> publisher);
                    executorService.execute(() -> {
                        requestContext.writeEntity();
                        publisher.close();
                    });
                    stage = requestBuilder.submit((Flow.Publisher)Multi.from((Flow.Publisher)publisher).map(DataChunk::create));
                }
            }
        }
        return stage;
    }

    private static class OutputStreamBodyWriter
    implements MessageBodyWriter {
        private OutputStreamBodyWriter() {
        }

        public Flow.Publisher<DataChunk> write(Single content, GenericType type, MessageBodyWriterContext context) {
            context.contentType(MediaType.APPLICATION_OCTET_STREAM);
            return content.flatMap((Function)new ByteArrayOutputStreamToChunks());
        }

        public boolean accept(GenericType type, MessageBodyContext context) {
            return ByteArrayOutputStream.class.isAssignableFrom(type.rawType());
        }

        private static class ByteArrayOutputStreamToChunks
        implements Function<ByteArrayOutputStream, Flow.Publisher<DataChunk>> {
            private ByteArrayOutputStreamToChunks() {
            }

            @Override
            public Flow.Publisher<DataChunk> apply(ByteArrayOutputStream byteArrayOutputStream) {
                return ContentWriters.writeBytes((byte[])byteArrayOutputStream.toByteArray(), (boolean)false);
            }
        }
    }

    @FunctionalInterface
    private static interface ProcessingRunnable
    extends Runnable {
        public void runOrThrow() throws IOException;

        @Override
        default public void run() {
            try {
                this.runOrThrow();
            }
            catch (IOException e) {
                throw new ProcessingException(LocalizationMessages.ERROR_WRITING_ENTITY(e.getMessage()), (Throwable)e);
            }
        }
    }

    static enum HelidonEntityType {
        BYTE_ARRAY_OUTPUT_STREAM,
        READABLE_BYTE_CHANNEL,
        OUTPUT_STREAM_PUBLISHER;

    }
}

