/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.helidon.connector;

import io.helidon.common.http.Headers;
import io.helidon.common.http.ReadOnlyParameters;
import io.helidon.config.Config;
import io.helidon.config.ConfigSources;
import io.helidon.media.common.InputStreamBodyReader;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.webclient.Proxy;
import io.helidon.webclient.Ssl;
import io.helidon.webclient.WebClientResponse;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.helidon.connector.HelidonConnector;
import org.glassfish.jersey.helidon.connector.LocalizationMessages;

class HelidonStructures {
    HelidonStructures() {
    }

    static Headers createHeaders(Map<String, List<String>> data) {
        return new ReadOnlyHeaders(data);
    }

    static MessageBodyReader<InputStream> createInputStreamBodyReader() {
        return InputStreamBodyReader.create();
    }

    static Optional<Config> helidonConfig(Configuration configuration) {
        Object helidonConfig = configuration.getProperty("jersey.config.helidon.client.config");
        if (helidonConfig != null) {
            if (!Config.class.isInstance(helidonConfig)) {
                HelidonConnector.LOGGER.warning(LocalizationMessages.NOT_HELIDON_CONFIG(helidonConfig.getClass().getName()));
                return Optional.empty();
            }
            return Optional.of((Config)helidonConfig);
        }
        return Optional.empty();
    }

    static Optional<Proxy> createProxy(Configuration config) {
        return ProxyBuilder.createProxy(config);
    }

    static Optional<Proxy> createProxy(ClientRequest request) {
        return ProxyBuilder.createProxy(request);
    }

    static Optional<Ssl> createSSL(SSLContext context) {
        return context == null ? Optional.empty() : Optional.of(Ssl.builder().sslContext(context).build());
    }

    static boolean hasEntity(WebClientResponse webClientResponse) {
        ReadOnlyParameters headers = webClientResponse.content().readerContext().headers();
        Optional contentLenth = headers.first("Content-Length");
        Optional encoding = headers.first("Transfer-Encoding");
        return contentLenth.isPresent() && !((String)contentLenth.get()).equals("0") || encoding.isPresent() && ((String)encoding.get()).equals(HttpHeaderValues.CHUNKED.toString());
    }

    private static class ProxyBuilder {
        private ProxyBuilder() {
        }

        private static Optional<Proxy> createProxy(Configuration config) {
            Object proxyUri = config.getProperty("jersey.config.client.proxy.uri");
            String userName = (String)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.proxy.username", String.class);
            String password = (String)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.proxy.password", String.class);
            return ProxyBuilder.createProxy(proxyUri, userName, password);
        }

        private static Optional<Proxy> createProxy(ClientRequest clientRequest) {
            Object proxyUri = clientRequest.resolveProperty("jersey.config.client.proxy.uri", Object.class);
            String userName = (String)clientRequest.resolveProperty("jersey.config.client.proxy.username", String.class);
            String password = (String)clientRequest.resolveProperty("jersey.config.client.proxy.password", String.class);
            return ProxyBuilder.createProxy(proxyUri, userName, password);
        }

        private static Optional<Proxy> createProxy(Object proxyUri, String userName, String password) {
            if (proxyUri != null) {
                URI u = ProxyBuilder.getProxyUri(proxyUri);
                Proxy.Builder builder = Proxy.builder();
                if (u.getScheme().toUpperCase(Locale.ROOT).equals("DIRECT")) {
                    Map<String, String> proxyMap = Map.of("type", "NONE");
                } else {
                    Map<String, String> proxyMap;
                    builder.host(u.getHost()).port(u.getPort());
                    switch (u.getScheme().toUpperCase(Locale.ROOT)) {
                        case "HTTP": {
                            proxyMap = Map.of("type", "HTTP");
                            break;
                        }
                        case "SOCKS": {
                            proxyMap = Map.of("type", "SOCKS_4");
                            break;
                        }
                        case "SOCKS5": {
                            proxyMap = Map.of("type", "SOCKS_5");
                            break;
                        }
                        default: {
                            HelidonConnector.LOGGER.warning(LocalizationMessages.UNSUPPORTED_PROXY_SCHEMA(u.getScheme()));
                            return Optional.empty();
                        }
                    }
                    builder.config(Config.create((Supplier[])new Supplier[]{ConfigSources.create(proxyMap)}));
                }
                if (userName != null) {
                    builder.username(userName);
                    if (password != null) {
                        builder.password(password.toCharArray());
                    }
                }
                return Optional.of(builder.build());
            }
            return Optional.empty();
        }

        private static URI getProxyUri(Object proxy) {
            if (proxy instanceof URI) {
                return (URI)proxy;
            }
            if (proxy instanceof String) {
                return URI.create((String)proxy);
            }
            throw new ProcessingException(LocalizationMessages.WRONG_PROXY_URI_TYPE("jersey.config.client.proxy.uri"));
        }
    }

    private static class ReadOnlyHeaders
    extends ReadOnlyParameters
    implements Headers {
        public ReadOnlyHeaders(Map<String, List<String>> data) {
            super(data);
        }
    }
}

