
package org.glassfish.jersey.helidon.connector;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private static final String BUNDLE_NAME = "org.glassfish.jersey.helidon.connector.localization";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private LocalizationMessages() {
    }

    public static Localizable localizableNOT_SUPPORTED() {
        return MESSAGE_FACTORY.getMessage("not.supported");
    }

    /**
     * Helidon connector is not supported on JDK version less than 21.
     * 
     */
    public static String NOT_SUPPORTED() {
        return LOCALIZER.localize(localizableNOT_SUPPORTED());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
