
package org.glassfish.jersey.helidon.connector;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private static final String BUNDLE_NAME = "org.glassfish.jersey.helidon.connector.localization";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private LocalizationMessages() {
    }

    public static Localizable localizableHELIDON_3_NOT_SUPPORTED() {
        return MESSAGE_FACTORY.getMessage("helidon3.not.supported");
    }

    /**
     * Helidon connector is not supported on JDK version less than 17.
     * 
     */
    public static String HELIDON_3_NOT_SUPPORTED() {
        return LOCALIZER.localize(localizableHELIDON_3_NOT_SUPPORTED());
    }

    public static Localizable localizableWRONG_PROXY_URI_TYPE(Object arg0) {
        return MESSAGE_FACTORY.getMessage("wrong.proxy.uri.type", arg0);
    }

    /**
     * The proxy URI "{0}" MUST be String or URI.
     * 
     */
    public static String WRONG_PROXY_URI_TYPE(Object arg0) {
        return LOCALIZER.localize(localizableWRONG_PROXY_URI_TYPE(arg0));
    }

    public static Localizable localizablePROXY_SCHEMA_NOT_SUPPORTED(Object arg0) {
        return MESSAGE_FACTORY.getMessage("proxy.schema.not.supported", arg0);
    }

    /**
     * Proxy schema {0} not supported.
     * 
     */
    public static String PROXY_SCHEMA_NOT_SUPPORTED(Object arg0) {
        return LOCALIZER.localize(localizablePROXY_SCHEMA_NOT_SUPPORTED(arg0));
    }

    public static Localizable localizableHELIDON_CONFIG_IGNORED(Object arg0) {
        return MESSAGE_FACTORY.getMessage("helidon.config.ignored", arg0);
    }

    /**
     * Ignoring Helidon Connector config at "{0}".
     * 
     */
    public static String HELIDON_CONFIG_IGNORED(Object arg0) {
        return LOCALIZER.localize(localizableHELIDON_CONFIG_IGNORED(arg0));
    }

    public static Localizable localizableHELIDON_4_NOT_SUPPORTED() {
        return MESSAGE_FACTORY.getMessage("helidon4.not.supported");
    }

    /**
     * Helidon 4 connector is not supported on JDK version less than 21.
     * 
     */
    public static String HELIDON_4_NOT_SUPPORTED() {
        return LOCALIZER.localize(localizableHELIDON_4_NOT_SUPPORTED());
    }

    public static Localizable localizableNOT_SUPPORTED() {
        return MESSAGE_FACTORY.getMessage("not.supported");
    }

    /**
     * Helidon connector is not supported on JDK version less than 21.
     * 
     */
    public static String NOT_SUPPORTED() {
        return LOCALIZER.localize(localizableNOT_SUPPORTED());
    }

    public static Localizable localizableNO_CONFIG_IN_REGISTERY() {
        return MESSAGE_FACTORY.getMessage("no.config.in.registery");
    }

    /**
     * Unable to find Config in service registry.
     * 
     */
    public static String NO_CONFIG_IN_REGISTERY() {
        return LOCALIZER.localize(localizableNO_CONFIG_IN_REGISTERY());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
