/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.helidon.connector;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Configuration;
import org.glassfish.jersey.Beta;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.helidon.connector.Helidon3ConnectorProvider;
import org.glassfish.jersey.helidon.connector.HelidonConnector;
import org.glassfish.jersey.helidon.connector.HelidonVersionChecker;
import org.glassfish.jersey.helidon.connector.LocalizationMessages;
import org.glassfish.jersey.internal.util.JdkVersion;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Beta
public class HelidonConnectorProvider
implements ConnectorProvider {
    private static final LazyValue<Helidon3ConnectorProvider> helidon3ConnectorProvider = Values.lazy(Helidon3ConnectorProvider::new);

    public Connector getConnector(Client client, Configuration runtimeConfig) {
        if (HelidonVersionChecker.VERSION.get() == HelidonVersionChecker.Version.VERSION_3) {
            return ((Helidon3ConnectorProvider)((Object)helidon3ConnectorProvider.get())).getConnector(client, runtimeConfig);
        }
        if (JdkVersion.getJdkVersion().getMajor() < 21) {
            throw new ProcessingException(LocalizationMessages.HELIDON_4_NOT_SUPPORTED());
        }
        return new HelidonConnector(client, runtimeConfig);
    }
}

