/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.helidon.connector;

import java.lang.reflect.Field;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class HelidonVersionChecker {
    static final LazyValue<Version> VERSION = Values.lazy(() -> {
        try {
            Field field = Class.forName("io.helidon.common.Version").getDeclaredField("VERSION");
            String version = (String)field.get(null);
            return version.startsWith("4") ? Version.VERSION_4 : Version.VERSION_3;
        }
        catch (Throwable throwable) {
            return Version.VERSION_3;
        }
    });

    HelidonVersionChecker() {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static enum Version {
        VERSION_3,
        VERSION_4;

    }
}

