/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.helidon.connector;

import io.helidon.webclient.api.Proxy;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Configuration;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.helidon.connector.HelidonConnector;
import org.glassfish.jersey.helidon.connector.LocalizationMessages;

class ProxyBuilder {
    static Optional<Proxy> createProxy(Configuration config) {
        Object proxyUri = config.getProperty("jersey.config.client.proxy.uri");
        String userName = (String)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.proxy.username", String.class);
        String password = (String)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.proxy.password", String.class);
        return ProxyBuilder.createProxy(proxyUri, userName, password);
    }

    static Optional<Proxy> createProxy(ClientRequest clientRequest) {
        Object proxyUri = clientRequest.resolveProperty("jersey.config.client.proxy.uri", Object.class);
        String userName = (String)clientRequest.resolveProperty("jersey.config.client.proxy.username", String.class);
        String password = (String)clientRequest.resolveProperty("jersey.config.client.proxy.password", String.class);
        return ProxyBuilder.createProxy(proxyUri, userName, password);
    }

    private ProxyBuilder() {
    }

    private static Optional<Proxy> createProxy(Object proxyUri, String userName, String password) {
        if (proxyUri != null) {
            URI u = ProxyBuilder.getProxyUri(proxyUri);
            Proxy.Builder builder = Proxy.builder();
            if (u.getScheme().toUpperCase(Locale.ROOT).equals("DIRECT")) {
                builder.type(Proxy.ProxyType.NONE);
            } else {
                builder.host(u.getHost()).port(u.getPort());
                if ("HTTP".equals(u.getScheme().toUpperCase(Locale.ROOT))) {
                    builder.type(Proxy.ProxyType.HTTP);
                } else {
                    HelidonConnector.LOGGER.log(System.Logger.Level.WARNING, LocalizationMessages.PROXY_SCHEMA_NOT_SUPPORTED(u.getScheme()));
                    return Optional.empty();
                }
            }
            if (userName != null) {
                builder.username(userName);
                if (password != null) {
                    builder.password(password.toCharArray());
                }
            }
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }

    private static URI getProxyUri(Object proxy) {
        if (proxy instanceof URI) {
            return (URI)proxy;
        }
        if (proxy instanceof String) {
            return URI.create((String)proxy);
        }
        throw new ProcessingException(LocalizationMessages.WRONG_PROXY_URI_TYPE(proxy));
    }
}

