/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector.internal;

import java.io.IOException;
import java.net.CookieManager;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ScheduledExecutorService;
import org.glassfish.jersey.jdk.connector.internal.CompletionHandler;
import org.glassfish.jersey.jdk.connector.internal.ConnectorConfiguration;
import org.glassfish.jersey.jdk.connector.internal.HttpConnection;
import org.glassfish.jersey.jdk.connector.internal.HttpRequest;
import org.glassfish.jersey.jdk.connector.internal.HttpResponse;
import org.glassfish.jersey.jdk.connector.internal.LocalizationMessages;
import org.glassfish.jersey.jdk.connector.internal.Utils;

class DestinationConnectionPool {
    private final ConnectorConfiguration configuration;
    private final Queue<HttpConnection> idleConnections = new ConcurrentLinkedDeque<HttpConnection>();
    private final Set<HttpConnection> connections = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Queue<RequestRecord> pendingRequests = new ConcurrentLinkedDeque<RequestRecord>();
    private final Map<HttpConnection, RequestRecord> requestsInProgress = new HashMap<HttpConnection, RequestRecord>();
    private final CookieManager cookieManager;
    private final ScheduledExecutorService scheduler;
    private final ConnectionStateListener connectionStateListener;
    private volatile ConnectionCloseListener connectionCloseListener;
    private int connectionCounter = 0;
    private boolean closed = false;

    DestinationConnectionPool(ConnectorConfiguration configuration, CookieManager cookieManager, ScheduledExecutorService scheduler) {
        this.configuration = configuration;
        this.cookieManager = cookieManager;
        this.scheduler = scheduler;
        this.connectionStateListener = new ConnectionStateListener();
    }

    void setConnectionCloseListener(ConnectionCloseListener connectionCloseListener) {
        this.connectionCloseListener = connectionCloseListener;
    }

    void send(HttpRequest httpRequest, CompletionHandler<HttpResponse> completionHandler) {
        this.pendingRequests.add(new RequestRecord(httpRequest, completionHandler));
        this.processPendingRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingRequests(HttpConnection connection) {
        CompletionHandler completionHandler;
        HttpRequest httpRequest;
        DestinationConnectionPool destinationConnectionPool = this;
        synchronized (destinationConnectionPool) {
            RequestRecord pendingHead = this.pendingRequests.poll();
            if (pendingHead == null) {
                this.idleConnections.add(connection);
                return;
            }
            httpRequest = pendingHead.request;
            completionHandler = pendingHead.completionHandler;
        }
        this.requestsInProgress.put(connection, new RequestRecord(httpRequest, completionHandler));
        connection.send(httpRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingRequests() {
        HttpConnection connection;
        CompletionHandler completionHandler;
        HttpRequest httpRequest;
        DestinationConnectionPool destinationConnectionPool = this;
        synchronized (destinationConnectionPool) {
            RequestRecord pendingHead = this.pendingRequests.peek();
            if (pendingHead == null) {
                return;
            }
            httpRequest = pendingHead.request;
            completionHandler = pendingHead.completionHandler;
            connection = this.idleConnections.poll();
            if (connection != null) {
                this.pendingRequests.poll();
            }
        }
        if (connection != null) {
            this.requestsInProgress.put(connection, new RequestRecord(httpRequest, completionHandler));
            connection.send(httpRequest);
            return;
        }
        destinationConnectionPool = this;
        synchronized (destinationConnectionPool) {
            if (this.configuration.getMaxConnectionsPerDestination() == this.connectionCounter) {
                return;
            }
            connection = new HttpConnection(httpRequest.getUri(), this.cookieManager, this.configuration, this.scheduler, this.connectionStateListener);
            this.connections.add(connection);
            ++this.connectionCounter;
        }
        connection.connect();
    }

    synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.connections.forEach(HttpConnection::close);
    }

    private RequestRecord getRequest(HttpConnection connection) {
        RequestRecord requestRecord = this.requestsInProgress.get(connection);
        if (requestRecord == null) {
            throw new IllegalStateException("Request not found");
        }
        return requestRecord;
    }

    private RequestRecord removeRequest(HttpConnection connection) {
        RequestRecord requestRecord = this.requestsInProgress.get(connection);
        if (requestRecord == null) {
            throw new IllegalStateException("Request not found");
        }
        return requestRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanClosedConnection(HttpConnection connection) {
        if (this.closed) {
            return;
        }
        DestinationConnectionPool destinationConnectionPool = this;
        synchronized (destinationConnectionPool) {
            this.idleConnections.remove(connection);
            this.connections.remove(connection);
            --this.connectionCounter;
            RequestRecord pendingRequest = this.pendingRequests.peek();
            if (pendingRequest == null) {
                if (this.connectionCounter == 0) {
                    this.connectionCloseListener.onLastConnectionClosed();
                }
                return;
            }
        }
        this.processPendingRequests();
    }

    private void handleIllegalStateTransition(HttpConnection.State oldState, HttpConnection.State newState) {
        throw new IllegalStateException("Illegal state transition, old state: " + (Object)((Object)oldState) + " new state: " + (Object)((Object)newState));
    }

    private synchronized void removeAllPendingWithError(Throwable t) {
        for (RequestRecord requestRecord : this.pendingRequests) {
            requestRecord.completionHandler.failed(t);
        }
        this.pendingRequests.clear();
    }

    static interface ConnectionCloseListener {
        public void onLastConnectionClosed();
    }

    static class DestinationKey {
        private final String host;
        private final int port;
        private final boolean secure;

        DestinationKey(URI uri) {
            this.host = uri.getHost();
            this.port = Utils.getPort(uri);
            this.secure = "https".equalsIgnoreCase(uri.getScheme());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DestinationKey that = (DestinationKey)o;
            return this.port == that.port && this.secure == that.secure && this.host.equals(that.host);
        }

        public int hashCode() {
            int result = this.host.hashCode();
            result = 31 * result + this.port;
            result = 31 * result + (this.secure ? 1 : 0);
            return result;
        }
    }

    private static class RequestRecord {
        private final HttpRequest request;
        private final CompletionHandler<HttpResponse> completionHandler;
        private HttpResponse response;

        RequestRecord(HttpRequest request, CompletionHandler<HttpResponse> completionHandler) {
            this.request = request;
            this.completionHandler = completionHandler;
        }
    }

    private class ConnectionStateListener
    implements HttpConnection.StateChangeListener {
        private ConnectionStateListener() {
        }

        @Override
        public void onStateChanged(HttpConnection connection, HttpConnection.State oldState, HttpConnection.State newState) {
            switch (newState) {
                case IDLE: {
                    switch (oldState) {
                        case RECEIVED: 
                        case CONNECTING: {
                            DestinationConnectionPool.this.processPendingRequests(connection);
                            return;
                        }
                    }
                    DestinationConnectionPool.this.handleIllegalStateTransition(oldState, newState);
                    return;
                }
                case RECEIVED: {
                    switch (oldState) {
                        case RECEIVING_HEADER: {
                            RequestRecord request = DestinationConnectionPool.this.removeRequest(connection);
                            request.completionHandler.completed(connection.getHttResponse());
                            return;
                        }
                        case RECEIVING_BODY: {
                            DestinationConnectionPool.this.removeRequest(connection);
                            return;
                        }
                    }
                    DestinationConnectionPool.this.handleIllegalStateTransition(oldState, newState);
                    return;
                }
                case RECEIVING_BODY: {
                    switch (oldState) {
                        case RECEIVING_HEADER: {
                            RequestRecord request = DestinationConnectionPool.this.getRequest(connection);
                            request.response = connection.getHttResponse();
                            request.completionHandler.completed(connection.getHttResponse());
                            return;
                        }
                    }
                    DestinationConnectionPool.this.handleIllegalStateTransition(oldState, newState);
                    return;
                }
                case ERROR: {
                    switch (oldState) {
                        case SENDING_REQUEST: {
                            RequestRecord request = DestinationConnectionPool.this.removeRequest(connection);
                            request.completionHandler.failed(connection.getError());
                            return;
                        }
                        case RECEIVING_HEADER: {
                            RequestRecord request = DestinationConnectionPool.this.removeRequest(connection);
                            request.completionHandler.failed(connection.getError());
                            return;
                        }
                        case RECEIVING_BODY: {
                            DestinationConnectionPool.this.requestsInProgress.remove(connection);
                            return;
                        }
                        case CONNECTING: {
                            DestinationConnectionPool.this.removeAllPendingWithError(connection.getError());
                            return;
                        }
                    }
                    connection.getError().printStackTrace();
                    DestinationConnectionPool.this.handleIllegalStateTransition(oldState, newState);
                    return;
                }
                case RESPONSE_TIMEOUT: {
                    switch (oldState) {
                        case RECEIVING_HEADER: {
                            RequestRecord request = DestinationConnectionPool.this.removeRequest(connection);
                            request.completionHandler.failed(new IOException(LocalizationMessages.TIMEOUT_RECEIVING_RESPONSE()));
                            return;
                        }
                        case RECEIVING_BODY: {
                            RequestRecord request = (RequestRecord)DestinationConnectionPool.this.requestsInProgress.remove(connection);
                            request.response.getBodyStream().notifyError(new IOException(LocalizationMessages.TIMEOUT_RECEIVING_RESPONSE_BODY()));
                            return;
                        }
                    }
                    DestinationConnectionPool.this.handleIllegalStateTransition(oldState, newState);
                    return;
                }
                case CLOSED_BY_SERVER: {
                    switch (oldState) {
                        case SENDING_REQUEST: {
                            RequestRecord request = DestinationConnectionPool.this.removeRequest(connection);
                            request.completionHandler.failed(new IOException(LocalizationMessages.CLOSED_WHILE_SENDING_REQUEST()));
                            return;
                        }
                        case RECEIVING_HEADER: {
                            RequestRecord request = DestinationConnectionPool.this.removeRequest(connection);
                            request.completionHandler.failed(new IOException(LocalizationMessages.CLOSED_WHILE_RECEIVING_RESPONSE(), connection.getError()));
                            return;
                        }
                        case RECEIVING_BODY: {
                            RequestRecord request = (RequestRecord)DestinationConnectionPool.this.requestsInProgress.remove(connection);
                            request.response.getBodyStream().notifyError(new IOException(LocalizationMessages.CLOSED_WHILE_RECEIVING_BODY(), connection.getError()));
                            return;
                        }
                        case CONNECTING: {
                            DestinationConnectionPool.this.removeAllPendingWithError(new IOException(LocalizationMessages.CONNECTION_CLOSED()));
                            return;
                        }
                    }
                }
                case CLOSED: {
                    switch (oldState) {
                        case SENDING_REQUEST: {
                            RequestRecord request = DestinationConnectionPool.this.removeRequest(connection);
                            request.completionHandler.failed(new IOException(LocalizationMessages.CLOSED_BY_CLIENT_WHILE_SENDING()));
                            DestinationConnectionPool.this.cleanClosedConnection(connection);
                            return;
                        }
                        case RECEIVING_HEADER: {
                            RequestRecord request = DestinationConnectionPool.this.removeRequest(connection);
                            request.completionHandler.failed(new IOException(LocalizationMessages.CLOSED_WHILE_RECEIVING_RESPONSE()));
                            DestinationConnectionPool.this.cleanClosedConnection(connection);
                            return;
                        }
                        case RECEIVING_BODY: {
                            RequestRecord request = (RequestRecord)DestinationConnectionPool.this.requestsInProgress.remove(connection);
                            request.response.getBodyStream().notifyError(new IOException(LocalizationMessages.CLOSED_BY_CLIENT_WHILE_RECEIVING_BODY(), connection.getError()));
                            DestinationConnectionPool.this.cleanClosedConnection(connection);
                            return;
                        }
                    }
                    DestinationConnectionPool.this.cleanClosedConnection(connection);
                    return;
                }
                case CONNECT_TIMEOUT: {
                    switch (oldState) {
                        case CONNECTING: {
                            DestinationConnectionPool.this.removeAllPendingWithError(new IOException(LocalizationMessages.CONNECTION_TIMEOUT()));
                            return;
                        }
                    }
                    DestinationConnectionPool.this.cleanClosedConnection(connection);
                }
            }
        }
    }
}

