/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.CookieManager;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.jdk.connector.internal.CompletionHandler;
import org.glassfish.jersey.jdk.connector.internal.ConnectorConfiguration;
import org.glassfish.jersey.jdk.connector.internal.HttpConnectionPool;
import org.glassfish.jersey.jdk.connector.internal.HttpRequest;
import org.glassfish.jersey.jdk.connector.internal.HttpResponse;
import org.glassfish.jersey.jdk.connector.internal.InterceptingOutputStream;
import org.glassfish.jersey.jdk.connector.internal.RedirectHandler;

public class JdkConnector
implements Connector {
    private final HttpConnectionPool httpConnectionPool;
    private final ConnectorConfiguration connectorConfiguration;

    public JdkConnector(Client client, Configuration config) {
        this.connectorConfiguration = new ConnectorConfiguration(client, config);
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(this.connectorConfiguration.getCookiePolicy());
        this.httpConnectionPool = new HttpConnectionPool(this.connectorConfiguration, cookieManager);
    }

    public ClientResponse apply(ClientRequest request) {
        Future<?> future = this.apply(request, new AsyncConnectorCallback(){

            public void response(ClientResponse response) {
            }

            public void failure(Throwable failure) {
            }
        });
        try {
            return (ClientResponse)future.get();
        }
        catch (Exception e) {
            throw new ProcessingException(this.unwrapExecutionException(e));
        }
    }

    private Throwable unwrapExecutionException(Throwable failure) {
        return failure != null && failure instanceof ExecutionException ? failure.getCause() : failure;
    }

    public Future<?> apply(ClientRequest request, final AsyncConnectorCallback callback) {
        final CompletableFuture responseFuture = new CompletableFuture();
        AsyncConnectorCallback internalCallback = new AsyncConnectorCallback(){

            public void response(ClientResponse response) {
                callback.response(response);
                responseFuture.complete(response);
            }

            public void failure(Throwable failure) {
                Throwable actualFailure = JdkConnector.this.unwrapExecutionException(failure);
                callback.failure(actualFailure);
                responseFuture.completeExceptionally(actualFailure);
            }
        };
        HttpRequest httpRequest = this.createHttpRequest(request);
        if (httpRequest.getBodyMode() == HttpRequest.BodyMode.BUFFERED) {
            this.writeBufferedEntity(request, httpRequest, internalCallback);
        }
        if (httpRequest.getBodyMode() == HttpRequest.BodyMode.BUFFERED || httpRequest.getBodyMode() == HttpRequest.BodyMode.NONE) {
            this.send(request, httpRequest, internalCallback);
        }
        if (httpRequest.getBodyMode() == HttpRequest.BodyMode.CHUNKED) {
            InterceptingOutputStream bodyStream = new InterceptingOutputStream(httpRequest.getBodyStream(), () -> this.send(request, httpRequest, internalCallback));
            request.setStreamProvider(contentLength -> bodyStream);
            try {
                request.writeEntity();
            }
            catch (IOException e) {
                internalCallback.failure((Throwable)e);
            }
        }
        return responseFuture;
    }

    private void writeBufferedEntity(ClientRequest request, HttpRequest httpRequest, AsyncConnectorCallback callback) {
        request.setStreamProvider(contentLength -> httpRequest.getBodyStream());
        try {
            request.writeEntity();
        }
        catch (IOException e) {
            callback.failure((Throwable)e);
        }
    }

    private void send(final ClientRequest request, HttpRequest httpRequest, final AsyncConnectorCallback callback) {
        this.translateHeaders(request, httpRequest);
        final RedirectHandler redirectHandler = new RedirectHandler(this.httpConnectionPool, httpRequest, this.connectorConfiguration);
        this.httpConnectionPool.send(httpRequest, new CompletionHandler<HttpResponse>(){

            @Override
            public void failed(Throwable throwable) {
                callback.failure(throwable);
            }

            @Override
            public void completed(HttpResponse result) {
                redirectHandler.handleRedirects(result, new CompletionHandler<HttpResponse>(){

                    @Override
                    public void failed(Throwable throwable) {
                        Throwable actualFailure = JdkConnector.this.unwrapExecutionException(throwable);
                        callback.failure(actualFailure);
                    }

                    @Override
                    public void completed(HttpResponse result) {
                        ClientResponse response = JdkConnector.this.translateResponse(request, result, redirectHandler.getLastRequestUri());
                        callback.response(response);
                    }
                });
            }
        });
    }

    private HttpRequest createHttpRequest(ClientRequest request) {
        Object entity = request.getEntity();
        if (entity == null) {
            return HttpRequest.createBodyless(request.getMethod(), request.getUri());
        }
        RequestEntityProcessing entityProcessing = (RequestEntityProcessing)request.resolveProperty("jersey.config.client.request.entity.processing", RequestEntityProcessing.class);
        HttpRequest httpRequest = entityProcessing != null && entityProcessing == RequestEntityProcessing.CHUNKED ? HttpRequest.createChunked(request.getMethod(), request.getUri(), this.connectorConfiguration.getChunkSize()) : HttpRequest.createBuffered(request.getMethod(), request.getUri());
        return httpRequest;
    }

    private Map<String, List<String>> translateHeaders(ClientRequest clientRequest, HttpRequest httpRequest) {
        Map<String, List<String>> headers = httpRequest.getHeaders();
        for (Map.Entry header : clientRequest.getStringHeaders().entrySet()) {
            ArrayList values = new ArrayList((Collection)header.getValue());
            headers.put((String)header.getKey(), values);
        }
        return headers;
    }

    private ClientResponse translateResponse(ClientRequest requestContext, final HttpResponse httpResponse, URI requestUri) {
        Response.StatusType statusType = new Response.StatusType(){

            public int getStatusCode() {
                return httpResponse.getStatusCode();
            }

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)httpResponse.getStatusCode());
            }

            public String getReasonPhrase() {
                return httpResponse.getReasonPhrase();
            }
        };
        ClientResponse responseContext = new ClientResponse(statusType, requestContext, requestUri);
        Map<String, List<String>> headers = httpResponse.getHeaders();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            for (String value : entry.getValue()) {
                responseContext.getHeaders().add((Object)entry.getKey(), (Object)value);
            }
        }
        responseContext.setEntityStream((InputStream)((Object)httpResponse.getBodyStream()));
        return responseContext;
    }

    public String getName() {
        return "JDK connector";
    }

    public void close() {
        this.httpConnectionPool.close();
    }
}

