/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector.internal;

import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import org.glassfish.jersey.jdk.connector.internal.Constants;
import org.glassfish.jersey.jdk.connector.internal.HttpParserUtils;
import org.glassfish.jersey.jdk.connector.internal.HttpResponse;
import org.glassfish.jersey.jdk.connector.internal.LocalizationMessages;
import org.glassfish.jersey.jdk.connector.internal.ParseException;
import org.glassfish.jersey.jdk.connector.internal.TransferEncodingParser;
import org.glassfish.jersey.jdk.connector.internal.Utils;

class HttpParser {
    private static final String ENCODING = "ISO-8859-1";
    private static final int BUFFER_STEP_SIZE = 256;
    static final int INIT_BUFFER_SIZE = 1024;
    private final HttpParserUtils.HeaderParsingState headerParsingState;
    private final int bufferMaxSize;
    private final int maxHeaderSize;
    private volatile ByteBuffer buffer = ByteBuffer.allocate(1024);
    private volatile boolean headerParsed;
    private volatile boolean expectContent;
    private volatile String protocolVersion;
    private volatile int code;
    private volatile HttpResponse httpResponse;
    private volatile TransferEncodingParser transferEncodingParser;
    private volatile boolean complete;

    HttpParser(int maxHeaderSize, int bufferMaxSize) {
        this.headerParsingState = new HttpParserUtils.HeaderParsingState(maxHeaderSize);
        this.bufferMaxSize = bufferMaxSize;
        this.maxHeaderSize = maxHeaderSize;
    }

    void reset(boolean expectContent) {
        this.expectContent = expectContent;
        this.headerParsed = false;
        ((Buffer)this.buffer).clear();
        ((Buffer)this.buffer).flip();
        this.complete = false;
        this.headerParsingState.recycle();
    }

    boolean isHeaderParsed() {
        return this.headerParsed;
    }

    boolean isComplete() {
        return this.complete;
    }

    HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    void parse(ByteBuffer input) throws ParseException {
        if (this.buffer.remaining() > 0) {
            input = Utils.appendBuffers(this.buffer, input, this.bufferMaxSize, 256);
        }
        if (!this.headerParsed && !this.parseHeader(input)) {
            this.saveRemaining(input);
            return;
        }
        this.httpResponse.setHasContent(this.expectContent);
        if (this.expectContent) {
            if (this.transferEncodingParser.parse(input)) {
                this.complete = true;
            } else {
                this.saveRemaining(input);
            }
        } else {
            this.complete = true;
        }
        if (this.complete && input.hasRemaining()) {
            throw new ParseException(LocalizationMessages.UNEXPECTED_DATA_IN_BUFFER());
        }
        if (this.complete) {
            this.httpResponse.getBodyStream().notifyAllDataRead();
        }
    }

    private void saveRemaining(ByteBuffer input) {
        this.headerParsingState.start = this.headerParsingState.start > 0 ? this.headerParsingState.start - input.position() : this.headerParsingState.start;
        this.headerParsingState.offset = this.headerParsingState.offset > 0 ? this.headerParsingState.offset - input.position() : this.headerParsingState.offset;
        this.headerParsingState.packetLimit = this.headerParsingState.packetLimit > 0 ? this.headerParsingState.packetLimit - input.position() : this.headerParsingState.packetLimit;
        this.headerParsingState.checkpoint = this.headerParsingState.checkpoint > 0 ? this.headerParsingState.checkpoint - input.position() : this.headerParsingState.checkpoint;
        int n = this.headerParsingState.checkpoint2 = this.headerParsingState.checkpoint2 > 0 ? this.headerParsingState.checkpoint2 - input.position() : this.headerParsingState.checkpoint2;
        if (input.hasRemaining()) {
            if (input != this.buffer) {
                ((Buffer)this.buffer).clear();
                ((Buffer)this.buffer).flip();
                this.buffer = Utils.appendBuffers(this.buffer, input, this.bufferMaxSize, 256);
            } else {
                this.buffer.compact();
                ((Buffer)this.buffer).flip();
            }
        }
    }

    private boolean parseHeader(ByteBuffer input) throws ParseException {
        block5: while (true) {
            switch (this.headerParsingState.state) {
                case 0: {
                    if (!this.decodeInitialLineFromBuffer(input)) {
                        this.headerParsingState.checkOverflow(LocalizationMessages.HTTP_INITIAL_LINE_OVERFLOW());
                        return false;
                    }
                    ++this.headerParsingState.state;
                    continue block5;
                }
                case 1: {
                    if (!this.parseHeadersFromBuffer(input, false)) {
                        this.headerParsingState.checkOverflow(LocalizationMessages.HTTP_PACKET_HEADER_OVERFLOW());
                        return false;
                    }
                    ++this.headerParsingState.state;
                    continue block5;
                }
                case 2: {
                    ((Buffer)input).position(this.headerParsingState.offset);
                    this.headerParsed = true;
                    this.decideTransferEncoding();
                    this.headerParsingState.recycle();
                    return true;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    private boolean decodeInitialLineFromBuffer(ByteBuffer input) throws ParseException {
        int packetLimit = this.headerParsingState.packetLimit;
        block7: while (true) {
            int subState = this.headerParsingState.subState++;
            switch (subState) {
                case 0: {
                    int spaceIdx = this.findSpace(input, this.headerParsingState.offset, packetLimit);
                    if (spaceIdx == -1) {
                        this.headerParsingState.offset = input.limit();
                        return false;
                    }
                    this.protocolVersion = this.parseString(input, this.headerParsingState.start, spaceIdx);
                    this.headerParsingState.start = -1;
                    this.headerParsingState.offset = spaceIdx;
                    continue block7;
                }
                case 1: {
                    int nonSpaceIdx = HttpParserUtils.skipSpaces(input, this.headerParsingState.offset, packetLimit);
                    if (nonSpaceIdx == -1) {
                        this.headerParsingState.offset = input.limit();
                        return false;
                    }
                    this.headerParsingState.start = nonSpaceIdx;
                    this.headerParsingState.offset = nonSpaceIdx + 1;
                    ++this.headerParsingState.subState;
                    continue block7;
                }
                case 2: {
                    if (this.headerParsingState.offset + 3 > input.limit()) {
                        return false;
                    }
                    this.code = this.parseInt(input, this.headerParsingState.start, this.headerParsingState.start + 3);
                    this.headerParsingState.start = -1;
                    this.headerParsingState.offset += 3;
                    ++this.headerParsingState.subState;
                    continue block7;
                }
                case 3: {
                    int nonSpaceIdx = HttpParserUtils.skipSpaces(input, this.headerParsingState.offset, packetLimit);
                    if (nonSpaceIdx == -1) {
                        this.headerParsingState.offset = input.limit();
                        return false;
                    }
                    this.headerParsingState.start = nonSpaceIdx;
                    this.headerParsingState.offset = nonSpaceIdx;
                    ++this.headerParsingState.subState;
                    continue block7;
                }
                case 4: {
                    if (!this.findEOL(input)) {
                        this.headerParsingState.offset = input.limit();
                        return false;
                    }
                    String reasonPhrase = this.parseString(input, this.headerParsingState.start, this.headerParsingState.checkpoint);
                    this.headerParsingState.subState = 0;
                    this.headerParsingState.start = -1;
                    this.headerParsingState.checkpoint = -1;
                    this.httpResponse = new HttpResponse(this.protocolVersion, this.code, reasonPhrase);
                    if (this.httpResponse.getStatusCode() == 100) {
                        this.headerParsingState.offset += 2;
                        this.headerParsingState.start = 0;
                        ((Buffer)input).position(this.headerParsingState.offset);
                        input.compact();
                        this.headerParsingState.offset = 0;
                        return false;
                    }
                    return true;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    boolean parseHeadersFromBuffer(ByteBuffer input, boolean parsingTrailerHeaders) throws ParseException {
        do {
            if (this.headerParsingState.subState != 0) continue;
            int eol = this.checkEOL(input);
            if (eol == 0) {
                return true;
            }
            if (eol != -2) continue;
            return false;
        } while (this.parseHeaderFromBuffer(input, parsingTrailerHeaders));
        return false;
    }

    private boolean parseHeaderFromBuffer(ByteBuffer input, boolean parsingTrailerHeaders) throws ParseException {
        block6: while (true) {
            int subState = this.headerParsingState.subState++;
            switch (subState) {
                case 0: {
                    this.headerParsingState.start = this.headerParsingState.offset;
                    continue block6;
                }
                case 1: {
                    if (!this.parseHeaderName(input)) {
                        return false;
                    }
                    ++this.headerParsingState.subState;
                    this.headerParsingState.start = -1;
                    continue block6;
                }
                case 2: {
                    int nonSpaceIdx = HttpParserUtils.skipSpaces(input, this.headerParsingState.offset, this.headerParsingState.packetLimit);
                    if (nonSpaceIdx == -1) {
                        this.headerParsingState.offset = input.limit();
                        return false;
                    }
                    ++this.headerParsingState.subState;
                    this.headerParsingState.offset = nonSpaceIdx;
                    if (this.headerParsingState.start != -1) continue block6;
                    this.headerParsingState.start = nonSpaceIdx;
                    this.headerParsingState.checkpoint = nonSpaceIdx;
                    this.headerParsingState.checkpoint2 = nonSpaceIdx;
                    continue block6;
                }
                case 3: {
                    int result = this.parseHeaderValue(input, parsingTrailerHeaders);
                    if (result == -1) {
                        return false;
                    }
                    if (result == -2) {
                        this.headerParsingState.subState = 2;
                        continue block6;
                    }
                    this.headerParsingState.subState = 0;
                    this.headerParsingState.start = -1;
                    return true;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    private boolean parseHeaderName(ByteBuffer input) throws ParseException {
        int offset;
        int limit = Math.min(input.limit(), this.headerParsingState.packetLimit);
        int start = this.headerParsingState.start;
        for (offset = this.headerParsingState.offset; offset < limit; ++offset) {
            byte b = input.get(offset);
            if (b == 58) {
                this.headerParsingState.headerName = this.parseString(input, start, offset);
                this.headerParsingState.offset = offset + 1;
                return true;
            }
            if (b < 65 || b > 90) continue;
            b = (byte)(b + 32);
            input.put(offset, b);
        }
        this.headerParsingState.offset = offset;
        return false;
    }

    private int parseHeaderValue(ByteBuffer input, boolean parsingTrailerHeaders) throws ParseException {
        boolean hasShift;
        int limit = Math.min(input.limit(), this.headerParsingState.packetLimit);
        int offset = this.headerParsingState.offset;
        boolean bl = hasShift = offset != this.headerParsingState.checkpoint;
        while (offset < limit) {
            byte b = input.get(offset);
            if (b == 44 && !this.isInseparableHeader()) {
                this.headerParsingState.offset = offset + 1;
                String value = this.parseString(input, this.headerParsingState.start, this.headerParsingState.checkpoint2);
                this.httpResponse.addHeader(this.headerParsingState.headerName, value);
                this.headerParsingState.start = this.headerParsingState.checkpoint2;
                return -2;
            }
            if (b != 13) {
                if (b == 10) {
                    if (offset + 1 < limit) {
                        byte b2 = input.get(offset + 1);
                        if (b2 == 32 || b2 == 9) {
                            input.put(this.headerParsingState.checkpoint++, b2);
                            this.headerParsingState.offset = offset + 2;
                            return -2;
                        }
                        this.headerParsingState.offset = offset + 1;
                        String value = this.parseString(input, this.headerParsingState.start, this.headerParsingState.checkpoint2);
                        if (parsingTrailerHeaders) {
                            this.httpResponse.addTrailerHeader(this.headerParsingState.headerName, value);
                        } else {
                            this.httpResponse.addHeader(this.headerParsingState.headerName, value);
                        }
                        return 0;
                    }
                    this.headerParsingState.offset = offset;
                    return -1;
                }
                if (b == 32) {
                    if (hasShift) {
                        input.put(this.headerParsingState.checkpoint++, b);
                    } else {
                        ++this.headerParsingState.checkpoint;
                    }
                } else {
                    if (hasShift) {
                        input.put(this.headerParsingState.checkpoint++, b);
                    }
                    this.headerParsingState.checkpoint2 = ++this.headerParsingState.checkpoint;
                }
            }
            ++offset;
        }
        this.headerParsingState.offset = offset;
        return -1;
    }

    private boolean isInseparableHeader() {
        return "WWW-Authenticate".equalsIgnoreCase(this.headerParsingState.headerName) || "Proxy-Authenticate".equalsIgnoreCase(this.headerParsingState.headerName) || "Set-Cookie".equalsIgnoreCase(this.headerParsingState.headerName);
    }

    private void decideTransferEncoding() throws ParseException {
        List<String> transferEncodings;
        int statusCode = this.httpResponse.getStatusCode();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.expectContent = false;
        }
        if (this.httpResponse.getHeaders().size() == 0) {
            this.expectContent = false;
        }
        if ((transferEncodings = this.httpResponse.getHeader(Constants.TRANSFER_ENCODING_HEADER)) != null) {
            String transferEncoding = transferEncodings.get(0);
            if (Constants.TRANSFER_ENCODING_CHUNKED.equalsIgnoreCase(transferEncoding)) {
                this.transferEncodingParser = TransferEncodingParser.createChunkParser(this.httpResponse.getBodyStream(), this, this.maxHeaderSize);
            }
            return;
        }
        List<String> contentLengths = this.httpResponse.getHeader("Content-Length");
        if (contentLengths != null) {
            try {
                long bodyLength = Long.parseLong(contentLengths.get(0));
                if (bodyLength == 0L) {
                    this.expectContent = false;
                    return;
                }
                if (bodyLength <= 0L) {
                    throw new ParseException(LocalizationMessages.HTTP_NEGATIVE_CONTENT_LENGTH());
                }
                this.transferEncodingParser = TransferEncodingParser.createFixedLengthParser(this.httpResponse.getBodyStream(), bodyLength);
            }
            catch (NumberFormatException e) {
                throw new ParseException(LocalizationMessages.HTTP_INVALID_CONTENT_LENGTH());
            }
            return;
        }
    }

    private int findSpace(ByteBuffer input, int offset, int packetLimit) {
        int limit = Math.min(input.limit(), packetLimit);
        while (offset < limit) {
            byte b = input.get(offset);
            if (HttpParserUtils.isSpaceOrTab(b)) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    private boolean findEOL(ByteBuffer input) {
        int offset;
        int limit = Math.min(input.limit(), this.headerParsingState.packetLimit);
        for (offset = this.headerParsingState.offset; offset < limit; ++offset) {
            byte b = input.get(offset);
            if (b == 13) {
                this.headerParsingState.checkpoint = offset;
                continue;
            }
            if (b != 10) continue;
            if (this.headerParsingState.checkpoint == -1) {
                this.headerParsingState.checkpoint = offset;
            }
            this.headerParsingState.offset = offset + 1;
            return true;
        }
        this.headerParsingState.offset = offset;
        return false;
    }

    private int checkEOL(ByteBuffer input) {
        byte b2;
        byte b1;
        int offset = this.headerParsingState.offset;
        int avail = input.limit() - offset;
        if (avail >= 2) {
            short s = input.getShort(offset);
            b1 = (byte)(s >>> 8);
            b2 = (byte)(s & 0xFF);
        } else if (avail == 1) {
            b1 = input.get(offset);
            b2 = -1;
        } else {
            return -2;
        }
        return this.checkCRLF(b1, b2);
    }

    private int checkCRLF(byte b1, byte b2) {
        if (b1 == 13) {
            if (b2 == 10) {
                this.headerParsingState.offset += 2;
                return 0;
            }
            if (b2 == -1) {
                return -2;
            }
        } else if (b1 == 10) {
            ++this.headerParsingState.offset;
            return 0;
        }
        return -1;
    }

    HttpParserUtils.HeaderParsingState getHeaderParsingState() {
        return this.headerParsingState;
    }

    private String parseString(ByteBuffer input, int startIdx, int endIdx) throws ParseException {
        byte[] bytes = new byte[endIdx - startIdx];
        ((Buffer)input).position(startIdx);
        input.get(bytes, 0, endIdx - startIdx);
        try {
            return new String(bytes, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new ParseException("Unsupported encoding: ISO-8859-1", e);
        }
    }

    private int parseInt(ByteBuffer input, int startIdx, int endIdx) throws ParseException {
        String value = this.parseString(input, startIdx, endIdx);
        return Integer.valueOf(value);
    }
}

