/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector.internal;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.glassfish.jersey.jdk.connector.internal.BodyOutputStream;
import org.glassfish.jersey.jdk.connector.internal.CompletionHandler;
import org.glassfish.jersey.jdk.connector.internal.Filter;
import org.glassfish.jersey.jdk.connector.internal.HttpRequestEncoder;
import org.glassfish.jersey.jdk.connector.internal.LocalizationMessages;
import org.glassfish.jersey.jdk.connector.internal.WriteListener;

class ChunkedBodyOutputStream
extends BodyOutputStream {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final int chunkSize;
    private final int encodedFullChunkSize;
    private final ByteBuffer dataBuffer;
    private final CountDownLatch initialBlockingLatch = new CountDownLatch(1);
    private volatile Filter<ByteBuffer, ?, ?, ?> downstreamFilter;
    private volatile WriteListener writeListener = null;
    private volatile Listener closeListener;
    private volatile Mode mode = Mode.UNDECIDED;
    private volatile boolean ready = false;
    private volatile boolean callListener = true;
    private volatile boolean closed = false;

    ChunkedBodyOutputStream(int chunkSize) {
        this.chunkSize = chunkSize;
        this.dataBuffer = ByteBuffer.allocate(chunkSize);
        this.encodedFullChunkSize = HttpRequestEncoder.getChunkSize(chunkSize);
    }

    @Override
    public synchronized void setWriteListener(WriteListener writeListener) {
        if (this.writeListener != null) {
            throw new IllegalStateException(LocalizationMessages.WRITE_LISTENER_SET_ONLY_ONCE());
        }
        this.assertAsynchronousOperation();
        this.writeListener = writeListener;
        this.commitToMode();
        if (this.ready && this.callListener) {
            this.callOnWritePossible();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.commitToMode();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.assertValidState();
        this.doInitialBlocking();
        if (len < this.dataBuffer.remaining()) {
            for (int i = off; i < off + len; ++i) {
                this.write(b[i]);
            }
        } else {
            int currentDataLength = this.dataBuffer.position() + len;
            int remainder = currentDataLength % this.dataBuffer.capacity();
            ByteBuffer buffer = ByteBuffer.allocate(currentDataLength - remainder);
            ((Buffer)this.dataBuffer).flip();
            buffer.put(this.dataBuffer);
            buffer.put(b, off, len - remainder);
            ((Buffer)buffer).flip();
            ((Buffer)this.dataBuffer).clear();
            this.dataBuffer.put(b, off + len - remainder, remainder);
            this.write(buffer);
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        if (this.mode == Mode.UNDECIDED) {
            return;
        }
        if (this.mode == Mode.ASYNCHRONOUS) {
            this.assertValidState();
        }
        if (this.dataBuffer.position() == 0) {
            return;
        }
        ((Buffer)this.dataBuffer).flip();
        this.write(this.dataBuffer);
    }

    @Override
    public void write(int b) throws IOException {
        this.commitToMode();
        this.assertValidState();
        this.doInitialBlocking();
        this.dataBuffer.put((byte)b);
        if (!this.dataBuffer.hasRemaining()) {
            ((Buffer)this.dataBuffer).flip();
            this.write(this.dataBuffer);
        }
    }

    @Override
    public boolean isReady() {
        this.assertAsynchronousOperation();
        if (!this.ready) {
            this.callListener = true;
        }
        return this.ready;
    }

    private void assertValidState() {
        if (this.closed) {
            throw new IllegalStateException(LocalizationMessages.STREAM_CLOSED());
        }
        if (this.mode == Mode.ASYNCHRONOUS && !this.ready) {
            throw new IllegalStateException(LocalizationMessages.WRITE_WHEN_NOT_READY());
        }
    }

    protected void write(final ByteBuffer byteBuffer) throws IOException {
        ByteBuffer httpChunk = this.encodeToHttp(byteBuffer);
        if (this.mode == Mode.SYNCHRONOUS) {
            final CountDownLatch writeLatch = new CountDownLatch(1);
            final AtomicReference error = new AtomicReference();
            this.downstreamFilter.write(httpChunk, new CompletionHandler<ByteBuffer>(){

                @Override
                public void completed(ByteBuffer result) {
                    writeLatch.countDown();
                }

                @Override
                public void failed(Throwable t) {
                    error.set(t);
                    writeLatch.countDown();
                }
            });
            try {
                writeLatch.await();
            }
            catch (InterruptedException e) {
                throw new IOException(LocalizationMessages.WRITING_FAILED(), e);
            }
            ((Buffer)byteBuffer).clear();
            Throwable t = (Throwable)error.get();
            if (t != null) {
                throw new IOException(LocalizationMessages.WRITING_FAILED(), t);
            }
        } else {
            this.ready = false;
            this.downstreamFilter.write(httpChunk, new CompletionHandler<ByteBuffer>(){

                @Override
                public void completed(ByteBuffer result) {
                    ChunkedBodyOutputStream.this.ready = true;
                    ((Buffer)byteBuffer).clear();
                    if (ChunkedBodyOutputStream.this.callListener) {
                        ChunkedBodyOutputStream.this.callOnWritePossible();
                    }
                }

                @Override
                public void failed(Throwable throwable) {
                    ChunkedBodyOutputStream.this.ready = false;
                    ChunkedBodyOutputStream.this.writeListener.onError(throwable);
                }
            });
        }
    }

    synchronized void open(Filter<ByteBuffer, ?, ?, ?> downstreamFilter) {
        this.downstreamFilter = downstreamFilter;
        this.initialBlockingLatch.countDown();
        this.ready = true;
        if (this.mode == Mode.ASYNCHRONOUS && this.writeListener != null) {
            this.callOnWritePossible();
        }
    }

    protected void doInitialBlocking() throws IOException {
        if (this.mode != Mode.SYNCHRONOUS || this.downstreamFilter != null) {
            return;
        }
        try {
            this.initialBlockingLatch.await();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    protected synchronized void commitToMode() {
        if (this.mode != Mode.UNDECIDED) {
            return;
        }
        if (this.writeListener != null) {
            this.mode = Mode.ASYNCHRONOUS;
            return;
        }
        this.mode = Mode.SYNCHRONOUS;
    }

    private void assertAsynchronousOperation() {
        if (this.mode == Mode.SYNCHRONOUS) {
            throw new UnsupportedOperationException(LocalizationMessages.ASYNC_OPERATION_NOT_SUPPORTED());
        }
    }

    private void callOnWritePossible() {
        this.callListener = false;
        try {
            this.writeListener.onWritePossible();
        }
        catch (IOException e) {
            this.writeListener.onError(e);
        }
    }

    synchronized void setCloseListener(Listener closeListener) {
        this.closeListener = closeListener;
    }

    protected ByteBuffer encodeToHttp(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < this.chunkSize) {
            return HttpRequestEncoder.encodeChunk(byteBuffer);
        }
        if (byteBuffer.remaining() % this.chunkSize != 0) {
            throw new IllegalStateException(LocalizationMessages.BUFFER_INCORRECT_LENGTH());
        }
        int numberOfChunks = byteBuffer.remaining() / this.chunkSize;
        ByteBuffer encodedChunks = ByteBuffer.allocate(numberOfChunks * this.encodedFullChunkSize);
        for (int i = 0; i < numberOfChunks; ++i) {
            ((Buffer)byteBuffer).position(i * this.chunkSize);
            ((Buffer)byteBuffer).limit(i * this.chunkSize + this.chunkSize);
            ByteBuffer encodeChunk = HttpRequestEncoder.encodeChunk(byteBuffer);
            encodedChunks.put(encodeChunk);
        }
        ((Buffer)encodedChunks).flip();
        return encodedChunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.commitToMode();
        this.doInitialBlocking();
        this.flush();
        this.write(EMPTY_BUFFER);
        super.close();
        this.closed = true;
        ChunkedBodyOutputStream chunkedBodyOutputStream = this;
        synchronized (chunkedBodyOutputStream) {
            if (this.closeListener != null) {
                this.closeListener.onClosed();
            }
        }
    }

    private static enum Mode {
        SYNCHRONOUS,
        ASYNCHRONOUS,
        UNDECIDED;

    }

    static interface Listener {
        public void onClosed();
    }
}

