/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import org.glassfish.jersey.internal.util.collection.ByteBufferInputStream;
import org.glassfish.jersey.jdk.connector.internal.BodyInputStream;
import org.glassfish.jersey.jdk.connector.internal.ReadListener;
import org.glassfish.jersey.jdk.connector.internal.l10n.LocalizationMessages;

class AsynchronousBodyInputStream
extends BodyInputStream {
    private static final ByteBuffer EOF = ByteBuffer.wrap(new byte[0]);
    private static final ByteBuffer ERROR = ByteBuffer.wrap(new byte[0]);
    private Mode mode = Mode.UNDECIDED;
    private ReadListener readListener = null;
    private boolean callReadListener = false;
    private Throwable t = null;
    private boolean closedForInput = false;
    private ExecutorService listenerExecutor = null;
    private StateChangeLister stateChangeLister;
    private ByteBufferInputStream synchronousStream = null;
    private Deque<ByteBuffer> data = new LinkedList<ByteBuffer>();

    AsynchronousBodyInputStream() {
    }

    synchronized void setListenerExecutor(ExecutorService listenerExecutor) {
        this.assertAsynchronousOperation();
        this.listenerExecutor = listenerExecutor;
        this.commitToMode();
    }

    @Override
    public synchronized boolean isReady() {
        this.assertAsynchronousOperation();
        if (this.mode == Mode.UNDECIDED) {
            return false;
        }
        ByteBuffer headBuffer = this.data.peek();
        boolean ready = true;
        if (headBuffer == null) {
            ready = false;
        }
        if (headBuffer == ERROR) {
            ready = false;
            this.callOnError(this.t);
        }
        if (headBuffer == EOF) {
            ready = false;
            this.callOnAllDataRead();
        }
        if (!ready) {
            this.callReadListener = true;
        }
        return ready;
    }

    @Override
    public synchronized void setReadListener(ReadListener readListener) {
        if (this.readListener != null) {
            throw new IllegalStateException(LocalizationMessages.READ_LISTENER_SET_ONLY_ONCE());
        }
        this.assertAsynchronousOperation();
        this.readListener = readListener;
        this.commitToMode();
        if (this.isReady()) {
            this.callDataAvailable();
        }
    }

    public int read() throws IOException {
        this.commitToMode();
        if (this.mode == Mode.SYNCHRONOUS) {
            return this.synchronousStream.read();
        }
        this.validateState();
        return this.doRead();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.commitToMode();
        if (this.mode == Mode.SYNCHRONOUS) {
            return this.synchronousStream.read(b, off, len);
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.validateState();
        for (int i = 0; i < len; ++i) {
            if (!this.hasDataToRead()) {
                return i;
            }
            b[off + i] = this.doRead();
        }
        return len;
    }

    private synchronized byte doRead() {
        ByteBuffer headBuffer = this.data.peek();
        byte b = headBuffer.get();
        if (!headBuffer.hasRemaining()) {
            this.data.poll();
        }
        return b;
    }

    public int available() throws IOException {
        this.commitToMode();
        this.assertSynchronousOperation();
        return this.synchronousStream.available();
    }

    public long skip(long n) throws IOException {
        this.commitToMode();
        this.assertSynchronousOperation();
        return this.synchronousStream.skip(n);
    }

    public int tryRead() throws IOException {
        this.commitToMode();
        this.assertSynchronousOperation();
        return this.synchronousStream.tryRead();
    }

    public int tryRead(byte[] b) throws IOException {
        this.commitToMode();
        this.assertSynchronousOperation();
        return this.synchronousStream.tryRead(b);
    }

    public int tryRead(byte[] b, int off, int len) throws IOException {
        this.commitToMode();
        this.assertSynchronousOperation();
        return this.synchronousStream.tryRead(b, off, len);
    }

    synchronized void notifyDataAvailable(ByteBuffer availableData) {
        this.assertClosedForInput();
        if (!availableData.hasRemaining()) {
            return;
        }
        if (this.mode == Mode.SYNCHRONOUS) {
            try {
                this.synchronousStream.put(availableData);
            }
            catch (InterruptedException e) {
                this.synchronousStream.closeQueue((Throwable)e);
            }
            return;
        }
        this.data.add(availableData);
        if (this.readListener != null && this.callReadListener) {
            this.callDataAvailable();
        }
    }

    public void close() throws IOException {
        if (this.mode == Mode.SYNCHRONOUS) {
            this.synchronousStream.close();
        }
    }

    synchronized void notifyError(Throwable t) {
        this.assertClosedForInput();
        if (this.stateChangeLister != null) {
            this.stateChangeLister.onError(t);
        }
        this.closedForInput = true;
        if (this.mode == Mode.SYNCHRONOUS) {
            this.synchronousStream.closeQueue(t);
            return;
        }
        this.t = t;
        this.data.add(ERROR);
        if (this.mode == Mode.ASYNCHRONOUS && this.callReadListener) {
            this.callOnError(t);
        }
    }

    synchronized void notifyAllDataRead() {
        this.assertClosedForInput();
        if (this.stateChangeLister != null) {
            this.stateChangeLister.onAllDataRead();
        }
        if (this.mode == Mode.SYNCHRONOUS) {
            this.synchronousStream.closeQueue();
            return;
        }
        this.data.add(EOF);
        if (this.mode == Mode.ASYNCHRONOUS && this.callReadListener) {
            this.callOnAllDataRead();
        }
    }

    private synchronized void commitToMode() {
        if (this.mode != Mode.UNDECIDED) {
            return;
        }
        if (this.readListener != null || this.listenerExecutor != null) {
            this.mode = Mode.ASYNCHRONOUS;
            return;
        }
        this.mode = Mode.SYNCHRONOUS;
        this.synchronousStream = new ByteBufferInputStream();
        for (ByteBuffer b : this.data) {
            if (b == EOF) {
                this.synchronousStream.closeQueue();
                continue;
            }
            if (b == ERROR) {
                this.synchronousStream.closeQueue(this.t);
                continue;
            }
            try {
                this.synchronousStream.put(b);
            }
            catch (InterruptedException e) {
                this.synchronousStream.closeQueue((Throwable)e);
            }
        }
    }

    private void assertAsynchronousOperation() {
        if (this.mode == Mode.SYNCHRONOUS) {
            throw new UnsupportedOperationException(LocalizationMessages.ASYNC_OPERATION_NOT_SUPPORTED());
        }
    }

    private void assertSynchronousOperation() {
        if (this.mode == Mode.ASYNCHRONOUS) {
            throw new UnsupportedOperationException(LocalizationMessages.SYNC_OPERATION_NOT_SUPPORTED());
        }
    }

    private void validateState() {
        if (this.mode == Mode.ASYNCHRONOUS && !this.hasDataToRead()) {
            throw new IllegalStateException(LocalizationMessages.WRITE_WHEN_NOT_READY());
        }
    }

    private void assertClosedForInput() {
        if (this.closedForInput) {
            throw new IllegalStateException(LocalizationMessages.STREAM_CLOSED_FOR_INPUT());
        }
    }

    private boolean hasDataToRead() {
        ByteBuffer headBuffer = this.data.peek();
        return headBuffer != null && headBuffer != EOF && headBuffer != ERROR && headBuffer.hasRemaining();
    }

    private void callDataAvailable() {
        this.callReadListener = false;
        if (this.listenerExecutor == null) {
            try {
                this.readListener.onDataAvailable();
            }
            catch (IOException e) {
                this.readListener.onError(e);
            }
        } else {
            this.listenerExecutor.submit(() -> {
                try {
                    this.readListener.onDataAvailable();
                }
                catch (IOException e) {
                    this.readListener.onError(e);
                }
            });
        }
    }

    private void callOnError(Throwable t) {
        if (this.listenerExecutor == null) {
            this.readListener.onError(t);
        } else {
            this.listenerExecutor.submit(() -> this.readListener.onError(t));
        }
    }

    private void callOnAllDataRead() {
        if (this.listenerExecutor == null) {
            try {
                this.readListener.onAllDataRead();
            }
            catch (IOException e) {
                this.readListener.onError(e);
            }
        } else {
            this.listenerExecutor.submit(() -> {
                try {
                    this.readListener.onAllDataRead();
                }
                catch (IOException e) {
                    this.readListener.onError(e);
                }
            });
        }
    }

    synchronized void setStateChangeLister(StateChangeLister stateChangeLister) {
        this.stateChangeLister = stateChangeLister;
        if (!this.data.isEmpty() && this.data.getLast() == EOF) {
            stateChangeLister.onAllDataRead();
        }
        if (!this.data.isEmpty() && this.data.getLast() == ERROR) {
            stateChangeLister.onError(this.t);
        }
    }

    private static enum Mode {
        SYNCHRONOUS,
        ASYNCHRONOUS,
        UNDECIDED;

    }

    static interface StateChangeLister {
        public void onError(Throwable var1);

        public void onAllDataRead();
    }
}

