/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector.internal;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.jdk.connector.internal.BodyOutputStream;
import org.glassfish.jersey.jdk.connector.internal.BufferedBodyOutputStream;
import org.glassfish.jersey.jdk.connector.internal.ChunkedBodyOutputStream;
import org.glassfish.jersey.jdk.connector.internal.l10n.LocalizationMessages;

class HttpRequest {
    private final String method;
    private final URI uri;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final BodyMode bodyMode;
    private final BodyOutputStream bodyStream;

    private HttpRequest(String method, URI uri, BodyMode bodyMode, BodyOutputStream bodyStream) {
        this.method = method;
        this.uri = uri;
        this.bodyMode = bodyMode;
        this.bodyStream = bodyStream;
    }

    static HttpRequest createBodyless(String method, URI uri) {
        HttpRequest httpRequest = new HttpRequest(method, uri, BodyMode.NONE, null);
        return httpRequest;
    }

    static HttpRequest createChunked(String method, URI uri, int chunkSize) {
        ChunkedBodyOutputStream bodyStream = new ChunkedBodyOutputStream(chunkSize);
        return new HttpRequest(method, uri, BodyMode.CHUNKED, bodyStream);
    }

    static HttpRequest createBuffered(String method, URI uri) {
        BufferedBodyOutputStream bodyOutputStream = new BufferedBodyOutputStream();
        return new HttpRequest(method, uri, BodyMode.BUFFERED, bodyOutputStream);
    }

    String getMethod() {
        return this.method;
    }

    URI getUri() {
        return this.uri;
    }

    Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    BodyMode getBodyMode() {
        return this.bodyMode;
    }

    BodyOutputStream getBodyStream() {
        if (BodyMode.NONE == this.bodyMode) {
            throw new IllegalStateException(LocalizationMessages.HTTP_REQUEST_NO_BODY());
        }
        return this.bodyStream;
    }

    void addHeaderIfNotPresent(String name, String value) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            this.headers.put(name, values);
            values.add(value);
        }
    }

    ByteBuffer getBufferedBody() {
        if (BodyMode.BUFFERED != this.bodyMode) {
            throw new IllegalStateException(LocalizationMessages.HTTP_REQUEST_NO_BUFFERED_BODY());
        }
        return ((BufferedBodyOutputStream)this.bodyStream).toBuffer();
    }

    int getBodySize() {
        if (this.bodyMode == BodyMode.CHUNKED) {
            throw new IllegalStateException(LocalizationMessages.HTTP_REQUEST_BODY_SIZE_NOT_AVAILABLE());
        }
        return ((BufferedBodyOutputStream)this.bodyStream).toBuffer().remaining();
    }

    static enum BodyMode {
        NONE,
        CHUNKED,
        BUFFERED;

    }
}

