/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jetty.connector;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieStore;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import jersey.repackaged.com.google.common.util.concurrent.FutureCallback;
import jersey.repackaged.com.google.common.util.concurrent.Futures;
import jersey.repackaged.com.google.common.util.concurrent.ListenableFuture;
import jersey.repackaged.com.google.common.util.concurrent.SettableFuture;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.OutputStreamContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.Jetty;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.collection.ByteBufferInputStream;
import org.glassfish.jersey.internal.util.collection.NonBlockingInputStream;
import org.glassfish.jersey.jetty.connector.LocalizationMessages;
import org.glassfish.jersey.message.internal.HeaderUtils;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.message.internal.Statuses;

class JettyConnector
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(JettyConnector.class.getName());
    private final HttpClient client;
    private final CookieStore cookieStore;

    JettyConnector(Client jaxrsClient, Configuration config) {
        Object proxyUri;
        Boolean disableCookies;
        Object threadPoolSize;
        SSLContext sslContext = this.getSslContext(jaxrsClient, config);
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setSslContext(sslContext);
        this.client = new HttpClient(sslContextFactory);
        Object connectTimeout = config.getProperties().get("jersey.config.client.connectTimeout");
        if (connectTimeout != null && connectTimeout instanceof Integer && (Integer)connectTimeout > 0) {
            this.client.setConnectTimeout((long)((Integer)connectTimeout).intValue());
        }
        if ((threadPoolSize = config.getProperties().get("jersey.config.client.async.threadPoolSize")) != null && threadPoolSize instanceof Integer && (Integer)threadPoolSize > 0) {
            String name = HttpClient.class.getSimpleName() + "@" + this.hashCode();
            QueuedThreadPool threadPool = new QueuedThreadPool(((Integer)threadPoolSize).intValue());
            threadPool.setName(name);
            this.client.setExecutor((Executor)threadPool);
        }
        disableCookies = (disableCookies = (Boolean)config.getProperties().get("jersey.config.jetty.client.disableCookies")) != null ? disableCookies : false;
        AuthenticationStore auth = this.client.getAuthenticationStore();
        Object basicAuthProvider = config.getProperty("jersey.config.jetty.client.preemptiveBasicAuthentication");
        if (basicAuthProvider != null && basicAuthProvider instanceof BasicAuthentication) {
            auth.addAuthentication((Authentication)((BasicAuthentication)basicAuthProvider));
        }
        if ((proxyUri = config.getProperties().get("jersey.config.client.proxy.uri")) != null) {
            URI u = JettyConnector.getProxyUri(proxyUri);
            ProxyConfiguration proxyConfig = this.client.getProxyConfiguration();
            proxyConfig.getProxies().add(new HttpProxy(u.getHost(), u.getPort()));
        }
        if (disableCookies.booleanValue()) {
            this.client.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        }
        try {
            this.client.start();
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to start the client.", (Throwable)e);
        }
        this.cookieStore = this.client.getCookieStore();
    }

    private SSLContext getSslContext(Client client, Configuration config) {
        SslConfigurator sslConfigurator = (SslConfigurator)PropertiesHelper.getValue((Map)config.getProperties(), (String)"jersey.config.jetty.client.ssl.sslConfig", SslConfigurator.class, null);
        return sslConfigurator != null ? sslConfigurator.createSSLContext() : client.getSslContext();
    }

    private static URI getProxyUri(Object proxy) {
        if (proxy instanceof URI) {
            return (URI)proxy;
        }
        if (proxy instanceof String) {
            return URI.create((String)proxy);
        }
        throw new ProcessingException(LocalizationMessages.WRONG_PROXY_URI_TYPE("jersey.config.client.proxy.uri"));
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public ClientResponse apply(ClientRequest jerseyRequest) throws ProcessingException {
        Request jettyRequest = this.translateRequest(jerseyRequest);
        Map<String, String> clientHeadersSnapshot = JettyConnector.writeOutBoundHeaders((MultivaluedMap<String, Object>)jerseyRequest.getHeaders(), jettyRequest);
        ContentProvider entity = this.getBytesProvider(jerseyRequest);
        if (entity != null) {
            jettyRequest.content(entity);
        }
        try {
            ContentResponse jettyResponse = jettyRequest.send();
            HeaderUtils.checkHeaderChanges(clientHeadersSnapshot, (MultivaluedMap)jerseyRequest.getHeaders(), (String)this.getClass().getName());
            Response.StatusType status = jettyResponse.getReason() == null ? Statuses.from((int)jettyResponse.getStatus()) : Statuses.from((int)jettyResponse.getStatus(), (String)jettyResponse.getReason());
            ClientResponse jerseyResponse = new ClientResponse(status, jerseyRequest);
            JettyConnector.processResponseHeaders(jettyResponse.getHeaders(), jerseyResponse);
            try {
                jerseyResponse.setEntityStream((InputStream)new HttpClientResponseInputStream(jettyResponse));
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, null, e);
            }
            return jerseyResponse;
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private static void processResponseHeaders(HttpFields respHeaders, ClientResponse jerseyResponse) {
        for (HttpField header : respHeaders) {
            String headerName = header.getName();
            MultivaluedMap headers = jerseyResponse.getHeaders();
            ArrayList<String> list = (ArrayList<String>)headers.get((Object)headerName);
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(header.getValue());
            headers.put((Object)headerName, list);
        }
    }

    private Request translateRequest(ClientRequest clientRequest) {
        HttpMethod method = HttpMethod.fromString((String)clientRequest.getMethod());
        if (method == null) {
            throw new ProcessingException(LocalizationMessages.METHOD_NOT_SUPPORTED(clientRequest.getMethod()));
        }
        URI uri = clientRequest.getUri();
        Request request = this.client.newRequest(uri);
        request.method(method);
        request.followRedirects(((Boolean)clientRequest.resolveProperty("jersey.config.client.followRedirects", (Object)true)).booleanValue());
        Object readTimeout = clientRequest.getConfiguration().getProperties().get("jersey.config.client.readTimeout");
        if (readTimeout != null && readTimeout instanceof Integer && (Integer)readTimeout > 0) {
            request.timeout((long)((Integer)readTimeout).intValue(), TimeUnit.MILLISECONDS);
        }
        return request;
    }

    private static Map<String, String> writeOutBoundHeaders(MultivaluedMap<String, Object> headers, Request request) {
        Map stringHeaders = HeaderUtils.asStringHeadersSingleValue(headers);
        for (Map.Entry e : stringHeaders.entrySet()) {
            request.getHeaders().add((String)e.getKey(), (String)e.getValue());
        }
        return stringHeaders;
    }

    private ContentProvider getBytesProvider(ClientRequest clientRequest) {
        Object entity = clientRequest.getEntity();
        if (entity == null) {
            return null;
        }
        final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        clientRequest.setStreamProvider(new OutboundMessageContext.StreamProvider(){

            public OutputStream getOutputStream(int contentLength) throws IOException {
                return outputStream;
            }
        });
        try {
            clientRequest.writeEntity();
        }
        catch (IOException e) {
            throw new ProcessingException("Failed to write request entity.", (Throwable)e);
        }
        return new BytesContentProvider((byte[][])new byte[][]{outputStream.toByteArray()});
    }

    private ContentProvider getStreamProvider(ClientRequest clientRequest) {
        Object entity = clientRequest.getEntity();
        if (entity == null) {
            return null;
        }
        final OutputStreamContentProvider streamContentProvider = new OutputStreamContentProvider();
        clientRequest.setStreamProvider(new OutboundMessageContext.StreamProvider(){

            public OutputStream getOutputStream(int contentLength) throws IOException {
                return streamContentProvider.getOutputStream();
            }
        });
        try {
            clientRequest.writeEntity();
        }
        catch (IOException e) {
            throw new ProcessingException("Failed to write request entity.", (Throwable)e);
        }
        return streamContentProvider;
    }

    public Future<?> apply(final ClientRequest jerseyRequest, final AsyncConnectorCallback callback) {
        final Request jettyRequest = this.translateRequest(jerseyRequest);
        final Map<String, String> clientHeadersSnapshot = JettyConnector.writeOutBoundHeaders((MultivaluedMap<String, Object>)jerseyRequest.getHeaders(), jettyRequest);
        ContentProvider entity = this.getStreamProvider(jerseyRequest);
        if (entity != null) {
            jettyRequest.content(entity);
        }
        final AtomicBoolean callbackInvoked = new AtomicBoolean(false);
        try {
            final SettableFuture responseFuture = SettableFuture.create();
            Futures.addCallback((ListenableFuture)responseFuture, (FutureCallback)new FutureCallback<ClientResponse>(){

                public void onSuccess(ClientResponse result) {
                }

                public void onFailure(Throwable t) {
                    if (t instanceof CancellationException) {
                        jettyRequest.abort(t);
                    }
                }
            });
            final AtomicReference jerseyResponse = new AtomicReference();
            final ByteBufferInputStream entityStream = new ByteBufferInputStream();
            jettyRequest.send((Response.CompleteListener)new Response.Listener.Adapter(){

                public void onHeaders(Response jettyResponse) {
                    HeaderUtils.checkHeaderChanges((Map)clientHeadersSnapshot, (MultivaluedMap)jerseyRequest.getHeaders(), (String)JettyConnector.this.getClass().getName());
                    if (responseFuture.isDone() && !callbackInvoked.compareAndSet(false, true)) {
                        return;
                    }
                    ClientResponse response = JettyConnector.translateResponse(jerseyRequest, jettyResponse, (NonBlockingInputStream)entityStream);
                    jerseyResponse.set(response);
                    callback.response(response);
                }

                public void onContent(Response jettyResponse, ByteBuffer content) {
                    try {
                        entityStream.put(content);
                    }
                    catch (InterruptedException ex) {
                        ProcessingException pe = new ProcessingException((Throwable)ex);
                        entityStream.closeQueue((Throwable)pe);
                        responseFuture.setException((Throwable)pe);
                        Thread.currentThread().interrupt();
                    }
                }

                public void onComplete(Result result) {
                    entityStream.closeQueue();
                    responseFuture.set(jerseyResponse.get());
                }

                public void onFailure(Response response, Throwable t) {
                    entityStream.closeQueue(t);
                    responseFuture.setException(t);
                    if (callbackInvoked.compareAndSet(false, true)) {
                        callback.failure(t);
                    }
                }
            });
            return responseFuture;
        }
        catch (Throwable t) {
            Throwable failure = t;
            if (callbackInvoked.compareAndSet(false, true)) {
                callback.failure(failure);
            }
            return Futures.immediateFailedFuture((Throwable)failure);
        }
    }

    private static ClientResponse translateResponse(ClientRequest jerseyRequest, Response jettyResponse, NonBlockingInputStream entityStream) {
        ClientResponse jerseyResponse = new ClientResponse(Statuses.from((int)jettyResponse.getStatus()), jerseyRequest);
        JettyConnector.processResponseHeaders(jettyResponse.getHeaders(), jerseyResponse);
        jerseyResponse.setEntityStream((InputStream)entityStream);
        return jerseyResponse;
    }

    public String getName() {
        return "Jetty HttpClient " + Jetty.VERSION;
    }

    public void close() {
        try {
            this.client.stop();
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to stop the client.", (Throwable)e);
        }
    }

    private static final class HttpClientResponseInputStream
    extends FilterInputStream {
        HttpClientResponseInputStream(ContentResponse jettyResponse) throws IOException {
            super(HttpClientResponseInputStream.getInputStream(jettyResponse));
        }

        private static InputStream getInputStream(ContentResponse response) {
            return new ByteArrayInputStream(response.getContent());
        }
    }
}

