
package org.glassfish.jersey.jetty.connector;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.jetty.connector.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableMETHOD_NOT_SUPPORTED(Object arg0) {
        return messageFactory.getMessage("method.not.supported", arg0);
    }

    /**
     * Method {0} not supported.
     * 
     */
    public static String METHOD_NOT_SUPPORTED(Object arg0) {
        return localizer.localize(localizableMETHOD_NOT_SUPPORTED(arg0));
    }

    public static Localizable localizableWRONG_PROXY_URI_TYPE(Object arg0) {
        return messageFactory.getMessage("wrong.proxy.uri.type", arg0);
    }

    /**
     * The proxy URI ("{0}") property MUST be an instance of String or URI.
     * 
     */
    public static String WRONG_PROXY_URI_TYPE(Object arg0) {
        return localizer.localize(localizableWRONG_PROXY_URI_TYPE(arg0));
    }

}
