
package org.glassfish.jersey.jetty.connector;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private static final String BUNDLE_NAME = "org.glassfish.jersey.jetty.connector.localization";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private LocalizationMessages() {
    }

    public static Localizable localizableINVALID_CONFIGURABLE_COMPONENT_TYPE(Object arg0) {
        return MESSAGE_FACTORY.getMessage("invalid.configurable.component.type", arg0);
    }

    /**
     * The supplied component "{0}" is not assignable from JerseyClient or JerseyWebTarget.
     * 
     */
    public static String INVALID_CONFIGURABLE_COMPONENT_TYPE(Object arg0) {
        return LOCALIZER.localize(localizableINVALID_CONFIGURABLE_COMPONENT_TYPE(arg0));
    }

    public static Localizable localizableMETHOD_NOT_SUPPORTED(Object arg0) {
        return MESSAGE_FACTORY.getMessage("method.not.supported", arg0);
    }

    /**
     * Method {0} not supported.
     * 
     */
    public static String METHOD_NOT_SUPPORTED(Object arg0) {
        return LOCALIZER.localize(localizableMETHOD_NOT_SUPPORTED(arg0));
    }

    public static Localizable localizableEXPECTED_CONNECTOR_PROVIDER_NOT_USED() {
        return MESSAGE_FACTORY.getMessage("expected.connector.provider.not.used");
    }

    /**
     * The supplied component is not configured to use a JettyConnectorProvider.
     * 
     */
    public static String EXPECTED_CONNECTOR_PROVIDER_NOT_USED() {
        return LOCALIZER.localize(localizableEXPECTED_CONNECTOR_PROVIDER_NOT_USED());
    }

    public static Localizable localizableNOT_SUPPORTED() {
        return MESSAGE_FACTORY.getMessage("not.supported");
    }

    /**
     * Jetty connector is not supported on JDK version less than 17.
     * 
     */
    public static String NOT_SUPPORTED() {
        return LOCALIZER.localize(localizableNOT_SUPPORTED());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
