/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jetty.http2.connector;

import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import org.eclipse.jetty.client.HttpClient;
import org.glassfish.jersey.client.Initializable;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.jetty.connector.JettyConnectorProvider;
import org.glassfish.jersey.jetty.connector.LocalizationMessages;
import org.glassfish.jersey.jetty.http2.connector.JettyHttp2Connector;

public class JettyHttp2ConnectorProvider
extends JettyConnectorProvider {
    public Connector getConnector(Client client, Configuration runtimeConfig) {
        return new JettyHttp2Connector(client, runtimeConfig);
    }

    public static HttpClient getHttpClient(Configurable<?> component) {
        if (!(component instanceof Initializable)) {
            throw new IllegalArgumentException(LocalizationMessages.INVALID_CONFIGURABLE_COMPONENT_TYPE((Object)component.getClass().getName()));
        }
        Initializable initializable = (Initializable)component;
        Connector connector = initializable.getConfiguration().getConnector();
        if (connector == null) {
            initializable.preInitialize();
            connector = initializable.getConfiguration().getConnector();
        }
        if (connector instanceof JettyHttp2Connector) {
            return ((JettyHttp2Connector)connector).getHttpClient();
        }
        throw new IllegalArgumentException(LocalizationMessages.EXPECTED_CONNECTOR_PROVIDER_NOT_USED());
    }
}

