/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jetty.http2.connector;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Configuration;
import java.util.Optional;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.transport.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.io.ClientConnector;
import org.glassfish.jersey.jetty.connector.JettyConnector;
import org.glassfish.jersey.jetty.http2.connector.JettyHttp2ClientSupplier;

class JettyHttp2Connector
extends JettyConnector {
    JettyHttp2Connector(Client jaxrsClient, Configuration config) {
        super(jaxrsClient, config);
    }

    protected HttpClientTransport initClientTransport(ClientConnector clientConnector) {
        return new HttpClientTransportOverHTTP2(new HTTP2Client(clientConnector));
    }

    protected HttpClient getRegisteredHttpClient(Configuration config) {
        Optional<Object> contract;
        if (config.isRegistered(JettyHttp2ClientSupplier.class) && (contract = config.getInstances().stream().filter(a -> JettyHttp2ClientSupplier.class.isInstance(a)).findFirst()).isPresent()) {
            return ((JettyHttp2ClientSupplier)contract.get()).getHttpClient();
        }
        return null;
    }
}

