/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jnh.connector;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.Version;
import org.glassfish.jersey.jnh.connector.LocalizationMessages;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.message.internal.Statuses;

public class JavaNetHttpConnector
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(JavaNetHttpConnector.class.getName());
    private final HttpClient httpClient;

    public JavaNetHttpConnector(Client client, Configuration configuration) {
        Boolean redirect;
        CookieHandler cookieHandler;
        Integer connectTimeout;
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        httpClientBuilder.version(HttpClient.Version.HTTP_1_1);
        SSLContext sslContext = client.getSslContext();
        if (sslContext != null) {
            httpClientBuilder.sslContext(sslContext);
        }
        if ((connectTimeout = this.getPropertyOrNull(configuration, "jersey.config.client.connectTimeout", Integer.class)) != null) {
            httpClientBuilder.connectTimeout(Duration.of(connectTimeout.intValue(), ChronoUnit.MILLIS));
        }
        if ((cookieHandler = this.getPropertyOrNull(configuration, "jersey.config.jnh.client.cookieHandler", CookieHandler.class)) != null) {
            httpClientBuilder.cookieHandler(cookieHandler);
        }
        if ((redirect = this.getPropertyOrNull(configuration, "jersey.config.client.followRedirects", Boolean.class)) != null) {
            httpClientBuilder.followRedirects(redirect != false ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER);
        } else {
            httpClientBuilder.followRedirects(HttpClient.Redirect.NORMAL);
        }
        SSLParameters sslParameters = this.getPropertyOrNull(configuration, "jersey.config.jnh.client.sslParameters", SSLParameters.class);
        if (sslParameters != null) {
            httpClientBuilder.sslParameters(sslParameters);
        }
        this.httpClient = httpClientBuilder.build();
    }

    private HttpRequest getHttpRequest(ClientRequest request) {
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        builder.uri(request.getUri());
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.noBody();
        if (request.hasEntity()) {
            try {
                request.enableBuffering();
                ByteArrayOutputStreamProvider byteBufferStreamProvider = new ByteArrayOutputStreamProvider();
                request.setStreamProvider((OutboundMessageContext.StreamProvider)byteBufferStreamProvider);
                request.writeEntity();
                bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(byteBufferStreamProvider.getByteArrayOutputStream().toByteArray());
            }
            catch (IOException e) {
                throw new ProcessingException(LocalizationMessages.ERROR_INVALID_ENTITY(), (Throwable)e);
            }
        }
        builder.method(request.getMethod(), bodyPublisher);
        for (Map.Entry entry : request.getRequestHeaders().entrySet()) {
            String headerName = (String)entry.getKey();
            for (String headerValue : (List)entry.getValue()) {
                builder.header(headerName, headerValue);
            }
        }
        return builder.build();
    }

    private <T> T getPropertyOrNull(Configuration configuration, String propertyKey, Class<T> resultClass) {
        Object propertyObject = configuration.getProperty(propertyKey);
        if (propertyObject == null) {
            return null;
        }
        if (!resultClass.isInstance(propertyObject)) {
            LOGGER.warning(LocalizationMessages.ERROR_INVALID_CLASS(propertyKey, resultClass.getName()));
            return null;
        }
        return (T)propertyObject;
    }

    private ClientResponse buildClientResponse(ClientRequest request, HttpResponse<InputStream> response) {
        ClientResponse clientResponse = new ClientResponse(Statuses.from((int)response.statusCode()), request);
        MultivaluedMap headers = clientResponse.getHeaders();
        for (Map.Entry<String, List<String>> entry : response.headers().map().entrySet()) {
            String headerName = entry.getKey();
            if (headers.get((Object)headerName) != null) {
                ((List)headers.get((Object)headerName)).addAll((Collection)entry.getValue());
                continue;
            }
            headers.put((Object)headerName, entry.getValue());
        }
        clientResponse.setEntityStream(response.body());
        return clientResponse;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public ClientResponse apply(ClientRequest request) {
        HttpRequest httpRequest = this.getHttpRequest(request);
        try {
            HttpResponse<InputStream> response = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
            return this.buildClientResponse(request, response);
        }
        catch (IOException | InterruptedException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public Future<?> apply(ClientRequest request, AsyncConnectorCallback callback) {
        HttpRequest httpRequest = this.getHttpRequest(request);
        CompletionStage response = this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofInputStream()).thenApply(httpResponse -> this.buildClientResponse(request, (HttpResponse<InputStream>)httpResponse));
        ((CompletableFuture)response).thenAccept(arg_0 -> ((AsyncConnectorCallback)callback).response(arg_0));
        return response;
    }

    public String getName() {
        return "Java HttpClient Connector " + Version.getVersion();
    }

    public void close() {
    }

    private static class ByteArrayOutputStreamProvider
    implements OutboundMessageContext.StreamProvider {
        private ByteArrayOutputStream byteArrayOutputStream;

        private ByteArrayOutputStreamProvider() {
        }

        public ByteArrayOutputStream getByteArrayOutputStream() {
            return this.byteArrayOutputStream;
        }

        public OutputStream getOutputStream(int contentLength) throws IOException {
            this.byteArrayOutputStream = new ByteArrayOutputStream(contentLength);
            return this.byteArrayOutputStream;
        }
    }
}

