/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jnh.connector;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.innate.ClientProxy;
import org.glassfish.jersey.client.innate.Expect100ContinueUsage;
import org.glassfish.jersey.client.innate.http.SSLParamConfigurator;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.Version;
import org.glassfish.jersey.jnh.connector.LocalizationMessages;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.message.internal.Statuses;

public class JavaNetHttpConnector
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(JavaNetHttpConnector.class.getName());
    private final HttpClient httpClient;

    public JavaNetHttpConnector(Client client, Configuration configuration) {
        Authenticator preemptiveAuthenticator;
        Boolean redirect;
        Boolean disableCookies;
        CookieHandler cookieHandler;
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        HttpClient.Version version = this.getPropertyOrNull(configuration, "jersey.config.jnh.client.httpVersion", HttpClient.Version.class);
        httpClientBuilder.version(version == null ? HttpClient.Version.HTTP_1_1 : version);
        SSLContext sslContext = client.getSslContext();
        if (sslContext != null) {
            httpClientBuilder.sslContext(sslContext);
        }
        if ((cookieHandler = this.getPropertyOrNull(configuration, "jersey.config.jnh.client.cookieHandler", CookieHandler.class)) != null) {
            httpClientBuilder.cookieHandler(cookieHandler);
        }
        if (Boolean.TRUE.equals(disableCookies = this.getPropertyOrNull(configuration, "jersey.config.jnh.client.disableCookies", Boolean.class))) {
            httpClientBuilder.cookieHandler(new CookieManager(null, CookiePolicy.ACCEPT_NONE));
        }
        if ((redirect = this.getPropertyOrNull(configuration, "jersey.config.client.followRedirects", Boolean.class)) != null) {
            httpClientBuilder.followRedirects(redirect != false ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER);
        } else {
            httpClientBuilder.followRedirects(HttpClient.Redirect.NORMAL);
        }
        SSLParameters sslParameters = this.getPropertyOrNull(configuration, "jersey.config.jnh.client.sslParameters", SSLParameters.class);
        sslParameters = new SniSslParameters(sslParameters).getSslParameters(client);
        if (sslParameters != null) {
            httpClientBuilder.sslParameters(sslParameters);
        }
        if ((preemptiveAuthenticator = this.getPropertyOrNull(configuration, "jersey.config.jnh.client.preemptiveBasicAuthentication", Authenticator.class)) != null) {
            httpClientBuilder.authenticator(preemptiveAuthenticator);
        }
        JavaNetHttpConnector.configureProxy(httpClientBuilder, configuration);
        this.httpClient = httpClientBuilder.build();
    }

    private static void configureProxy(HttpClient.Builder builder, Configuration config) {
        Optional proxy = ClientProxy.proxyFromConfiguration((Configuration)config);
        proxy.ifPresent(clientProxy -> {
            URI u = clientProxy.uri();
            InetSocketAddress proxyAddress = new InetSocketAddress(u.getHost(), u.getPort());
            if (clientProxy.userName() != null) {
                Authenticator authenticator = new Authenticator((ClientProxy)clientProxy){
                    final /* synthetic */ ClientProxy val$clientProxy;
                    {
                        this.val$clientProxy = clientProxy;
                    }

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(this.val$clientProxy.userName(), this.val$clientProxy.password() == null ? null : this.val$clientProxy.password().toCharArray());
                    }

                    @Override
                    protected Authenticator.RequestorType getRequestorType() {
                        return Authenticator.RequestorType.PROXY;
                    }
                };
                builder.authenticator(authenticator);
            }
            builder.proxy(ProxySelector.of(proxyAddress));
        });
    }

    private HttpRequest getHttpRequest(ClientRequest request) {
        SSLParamConfigurator sniConfig = SSLParamConfigurator.builder().uri(request.getUri()).configuration(request.getConfiguration()).build();
        URI sniUri = sniConfig.isSNIRequired() ? sniConfig.toIPRequestUri() : request.getUri();
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        builder.uri(sniUri);
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.noBody();
        if (request.hasEntity()) {
            try {
                ByteArrayOutputStreamProvider byteBufferStreamProvider = new ByteArrayOutputStreamProvider();
                request.setStreamProvider((OutboundMessageContext.StreamProvider)byteBufferStreamProvider);
                request.writeEntity();
                bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(byteBufferStreamProvider.getByteArrayOutputStream().toByteArray());
            }
            catch (IOException e) {
                throw new ProcessingException(LocalizationMessages.ERROR_INVALID_ENTITY(), (Throwable)e);
            }
        }
        builder.method(request.getMethod(), bodyPublisher);
        for (Map.Entry entry : request.getRequestHeaders().entrySet()) {
            String headerName = (String)entry.getKey();
            for (String headerValue : (List)entry.getValue()) {
                builder.header(headerName, headerValue);
            }
        }
        Integer connectTimeout = (Integer)request.resolveProperty("jersey.config.client.readTimeout", Integer.class);
        if (connectTimeout != null) {
            builder.timeout(Duration.ofMillis(connectTimeout.intValue()));
        }
        JavaNetHttpConnector.processExtensions(builder, request);
        return builder.build();
    }

    private static void processExtensions(HttpRequest.Builder builder, ClientRequest request) {
        builder.expectContinue(Expect100ContinueUsage.isAllowed((ClientRequest)request, (String)request.getMethod()));
    }

    private <T> T getPropertyOrNull(Configuration configuration, String propertyKey, Class<T> resultClass) {
        Object propertyObject = configuration.getProperty(propertyKey);
        if (propertyObject == null) {
            return null;
        }
        if (resultClass.isEnum() && propertyObject instanceof String) {
            return (T)Enum.valueOf(resultClass.asSubclass(Enum.class), (String)propertyObject);
        }
        if (!resultClass.isInstance(propertyObject)) {
            LOGGER.warning(LocalizationMessages.ERROR_INVALID_CLASS(propertyKey, resultClass.getName()));
            return null;
        }
        return (T)propertyObject;
    }

    private ClientResponse buildClientResponse(ClientRequest request, HttpResponse<InputStream> response) {
        ClientResponse clientResponse = new ClientResponse(Statuses.from((int)response.statusCode()), request);
        MultivaluedMap headers = clientResponse.getHeaders();
        for (Map.Entry<String, List<String>> entry : response.headers().map().entrySet()) {
            String headerName = entry.getKey();
            if (headers.get((Object)headerName) != null) {
                ((List)headers.get((Object)headerName)).addAll((Collection)entry.getValue());
                continue;
            }
            headers.put((Object)headerName, entry.getValue());
        }
        InputStream body = response.body();
        try {
            clientResponse.setEntityStream(body.available() != 1 ? body : new FirstByteCachingStream(body));
        }
        catch (IOException ioe) {
            throw new ProcessingException((Throwable)ioe);
        }
        return clientResponse;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public ClientResponse apply(ClientRequest request) {
        HttpRequest httpRequest = this.getHttpRequest(request);
        try {
            HttpResponse<InputStream> response = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
            return this.buildClientResponse(request, response);
        }
        catch (IOException | InterruptedException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public Future<?> apply(ClientRequest request, AsyncConnectorCallback callback) {
        HttpRequest httpRequest = this.getHttpRequest(request);
        CompletionStage response = this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofInputStream()).thenApply(httpResponse -> this.buildClientResponse(request, (HttpResponse<InputStream>)httpResponse));
        ((CompletableFuture)response).thenAccept(arg_0 -> ((AsyncConnectorCallback)callback).response(arg_0));
        return response;
    }

    public String getName() {
        return "Java HttpClient Connector " + Version.getVersion();
    }

    public void close() {
    }

    public CookieHandler getCookieHandler() {
        Optional<CookieHandler> cookieHandler = this.httpClient.cookieHandler();
        if (cookieHandler.isPresent()) {
            return cookieHandler.get();
        }
        return null;
    }

    private static class SniSslParameters {
        private final SSLParameters sslParameters;

        private SniSslParameters(SSLParameters sslParameters) {
            this.sslParameters = sslParameters;
        }

        private SSLParameters getSslParameters(Client client) {
            SSLParamConfigurator sniConfig = SSLParamConfigurator.builder().configuration(client.getConfiguration()).build();
            if (sniConfig.isSNIRequired()) {
                SSLParameters sslParameters = this.sslParameters;
                if (sslParameters == null) {
                    sslParameters = new SSLParameters();
                }
                sniConfig.setSNIServerName(sslParameters);
                return sslParameters;
            }
            return this.sslParameters;
        }
    }

    private static class ByteArrayOutputStreamProvider
    implements OutboundMessageContext.StreamProvider {
        private ByteArrayOutputStream byteArrayOutputStream;

        private ByteArrayOutputStreamProvider() {
        }

        public ByteArrayOutputStream getByteArrayOutputStream() {
            return this.byteArrayOutputStream;
        }

        public OutputStream getOutputStream(int contentLength) throws IOException {
            this.byteArrayOutputStream = contentLength > 0 ? new ByteArrayOutputStream(contentLength) : new ByteArrayOutputStream();
            return this.byteArrayOutputStream;
        }
    }

    private static class FirstByteCachingStream
    extends InputStream {
        private final InputStream inner;
        private volatile int zero = -1;
        private final Lock lock = new ReentrantLock();

        private FirstByteCachingStream(InputStream inner) {
            this.inner = inner;
        }

        @Override
        public int read() throws IOException {
            this.lock.lock();
            try {
                int r = this.zero != -1 ? this.zero : this.inner.read();
                this.zero = -1;
                int n = r;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int r;
            this.lock.lock();
            try {
                if (this.zero != -1) {
                    b[off] = (byte)(this.zero & 0xFF);
                    r = this.inner.read(b, off + 1, len - 1);
                    r = r == -1 ? 1 : r + 1;
                } else {
                    r = this.inner.read(b, off, len);
                }
                this.zero = -1;
            }
            finally {
                this.lock.unlock();
            }
            return r;
        }

        @Override
        public int available() throws IOException {
            this.lock.lock();
            try {
                if (this.zero != -1) {
                    int n = 1;
                    return n;
                }
                int available = this.inner.available();
                if (available != 1) {
                    int n = available;
                    return n;
                }
                this.zero = this.inner.read();
                if (this.zero == -1) {
                    available = 0;
                }
                int n = available;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void close() throws IOException {
            this.inner.close();
            this.lock.lock();
            this.zero = -1;
            this.lock.unlock();
        }

        @Override
        public boolean markSupported() {
            return this.inner.markSupported();
        }

        @Override
        public void mark(int readlimit) {
            this.inner.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.inner.reset();
        }
    }
}

