/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import javax.ws.rs.core.Response;
import jersey.repackaged.com.google.common.util.concurrent.SettableFuture;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.netty.connector.NettyConnector;
import org.glassfish.jersey.netty.connector.internal.NettyInputStream;

class JerseyClientHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private final NettyConnector connector;
    private final LinkedBlockingDeque<InputStream> isList = new LinkedBlockingDeque();
    private final AsyncConnectorCallback asyncConnectorCallback;
    private final ClientRequest jerseyRequest;
    private final SettableFuture future;

    JerseyClientHandler(NettyConnector nettyConnector, ClientRequest request, AsyncConnectorCallback callback, SettableFuture future) {
        this.connector = nettyConnector;
        this.asyncConnectorCallback = callback;
        this.jerseyRequest = request;
        this.future = future;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpResponse) {
            final HttpResponse response = (HttpResponse)msg;
            final ClientResponse jerseyResponse = new ClientResponse(new Response.StatusType(){

                public int getStatusCode() {
                    return response.status().code();
                }

                public Response.Status.Family getFamily() {
                    return Response.Status.Family.familyOf((int)response.status().code());
                }

                public String getReasonPhrase() {
                    return response.status().reasonPhrase();
                }
            }, this.jerseyRequest);
            for (Map.Entry entry : response.headers().entries()) {
                jerseyResponse.getHeaders().add(entry.getKey(), entry.getValue());
            }
            if (response.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && HttpUtil.getContentLength((HttpMessage)response) > 0L || HttpUtil.isTransferEncodingChunked((HttpMessage)response)) {
                ctx.channel().closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                    public void operationComplete(Future<? super Void> future) throws Exception {
                        JerseyClientHandler.this.isList.add(NettyInputStream.END_OF_INPUT_ERROR);
                    }
                });
                jerseyResponse.setEntityStream((InputStream)new NettyInputStream(this.isList));
            } else {
                jerseyResponse.setEntityStream(new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return -1;
                    }
                });
            }
            if (this.asyncConnectorCallback != null) {
                this.connector.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        JerseyClientHandler.this.asyncConnectorCallback.response(jerseyResponse);
                        JerseyClientHandler.this.future.set((Object)jerseyResponse);
                    }
                });
            }
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ByteBuf content = httpContent.content();
            if (content.isReadable()) {
                byte[] bytes = new byte[content.readableBytes()];
                content.getBytes(content.readerIndex(), bytes);
                this.isList.add(new ByteArrayInputStream(bytes));
            }
            if (msg instanceof LastHttpContent) {
                this.isList.add(NettyInputStream.END_OF_INPUT);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, final Throwable cause) {
        if (this.asyncConnectorCallback != null) {
            this.connector.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    JerseyClientHandler.this.asyncConnectorCallback.failure(cause);
                }
            });
        }
        this.future.setException(cause);
        this.isList.add(NettyInputStream.END_OF_INPUT_ERROR);
    }
}

