/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;

public class JerseyChunkedInput
extends OutputStream
implements ChunkedInput<ByteBuf> {
    private static final ByteBuffer VOID = ByteBuffer.allocate(0);
    private static final int CAPACITY = 8;
    private static final int WRITE_TIMEOUT = 1000;
    private static final int READ_TIMEOUT = 1000;
    private final LinkedBlockingDeque<ByteBuffer> queue = new LinkedBlockingDeque(8);
    private final Channel ctx;
    private volatile boolean open = true;
    private volatile long offset = 0L;

    public JerseyChunkedInput(Channel ctx) {
        this.ctx = ctx;
        ctx.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                JerseyChunkedInput.this.open = false;
                JerseyChunkedInput.this.queue.clear();
                JerseyChunkedInput.this.close();
            }
        });
    }

    public boolean isEndOfInput() throws Exception {
        if (!this.open) {
            return true;
        }
        ByteBuffer peek = this.queue.peek();
        if (peek != null && peek == VOID) {
            this.queue.remove();
            this.open = false;
            return true;
        }
        return false;
    }

    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
        if (!this.open) {
            return null;
        }
        ByteBuffer top = this.queue.poll(1000L, TimeUnit.MILLISECONDS);
        if (top == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (top == VOID) {
            this.open = false;
            return null;
        }
        int topRemaining = top.remaining();
        ByteBuf buffer = allocator.buffer(topRemaining);
        buffer.setBytes(0, top);
        buffer.setIndex(0, topRemaining);
        if (top.remaining() > 0) {
            this.queue.addFirst(top);
        }
        this.offset += (long)topRemaining;
        return buffer;
    }

    public long length() {
        return -1L;
    }

    public long progress() {
        return this.offset;
    }

    @Override
    public void close() throws IOException {
        if (this.queue.size() == 8) {
            boolean offer = false;
            try {
                offer = this.queue.offer(VOID, 1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!offer) {
                this.queue.removeLast();
                this.queue.add(VOID);
            }
        } else {
            this.queue.add(VOID);
        }
        this.ctx.flush();
    }

    @Override
    public void write(final int b) throws IOException {
        this.write(new Provider<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.wrap(new byte[]{(byte)b});
            }
        });
    }

    @Override
    public void write(final byte[] b) throws IOException {
        this.write(new Provider<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.wrap(b);
            }
        });
    }

    @Override
    public void write(final byte[] b, final int off, final int len) throws IOException {
        this.write(new Provider<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.wrap(b, off, len);
            }
        });
    }

    @Override
    public void flush() throws IOException {
        this.ctx.flush();
    }

    private void write(Provider<ByteBuffer> bufferSupplier) throws IOException {
        this.checkClosed();
        try {
            boolean queued = this.queue.offer((ByteBuffer)bufferSupplier.get(), 1000L, TimeUnit.MILLISECONDS);
            if (!queued) {
                throw new IOException("Buffer overflow.");
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void checkClosed() throws IOException {
        if (!this.open) {
            throw new IOException("Stream already closed.");
        }
    }
}

