/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.LinkedBlockingDeque;

public class NettyInputStream
extends InputStream {
    private volatile boolean end = false;
    public static final InputStream END_OF_INPUT = new InputStream(){

        @Override
        public int read() throws IOException {
            return 0;
        }
    };
    public static final InputStream END_OF_INPUT_ERROR = new InputStream(){

        @Override
        public int read() throws IOException {
            return 0;
        }
    };
    private final LinkedBlockingDeque<InputStream> isList;

    public NettyInputStream(LinkedBlockingDeque<InputStream> isList) {
        this.isList = isList;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.end) {
            return -1;
        }
        try {
            InputStream take = this.isList.take();
            if (this.checkEndOfInput(take)) {
                return -1;
            }
            int read = take.read(b, off, len);
            if (take.available() > 0) {
                this.isList.addFirst(take);
            }
            return read;
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted.", e);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.end) {
            return -1;
        }
        try {
            InputStream take = this.isList.take();
            if (this.checkEndOfInput(take)) {
                return -1;
            }
            int read = take.read();
            if (take.available() > 0) {
                this.isList.addFirst(take);
            }
            return read;
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted.", e);
        }
    }

    @Override
    public int available() throws IOException {
        InputStream peek = this.isList.peek();
        if (peek != null) {
            return peek.available();
        }
        return 0;
    }

    private boolean checkEndOfInput(InputStream take) throws IOException {
        if (take == END_OF_INPUT) {
            this.end = true;
            return true;
        }
        if (take == END_OF_INPUT_ERROR) {
            this.end = true;
            throw new IOException("Connection was closed prematurely.");
        }
        return false;
    }
}

