/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.netty.connector.JerseyClientHandler;
import org.glassfish.jersey.netty.connector.LocalizationMessages;
import org.glassfish.jersey.netty.connector.internal.JerseyChunkedInput;

class NettyConnector
implements Connector {
    final ExecutorService executorService;
    final EventLoopGroup group;
    final Client client;

    NettyConnector(Client client) {
        Object threadPoolSize = client.getConfiguration().getProperties().get("jersey.config.client.async.threadPoolSize");
        this.executorService = threadPoolSize != null && threadPoolSize instanceof Integer && (Integer)threadPoolSize > 0 ? Executors.newFixedThreadPool((Integer)threadPoolSize) : Executors.newCachedThreadPool();
        this.group = new NioEventLoopGroup();
        this.client = client;
    }

    public ClientResponse apply(ClientRequest jerseyRequest) {
        final AtomicReference<Object> syncResponse = new AtomicReference<Object>(null);
        final AtomicReference<Object> syncException = new AtomicReference<Object>(null);
        try {
            java.util.concurrent.Future<?> resultFuture = this.apply(jerseyRequest, new AsyncConnectorCallback(){

                public void response(ClientResponse response) {
                    syncResponse.set(response);
                }

                public void failure(Throwable failure) {
                    syncException.set(failure);
                }
            });
            Integer timeout = (Integer)ClientProperties.getValue((Map)jerseyRequest.getConfiguration().getProperties(), (String)"jersey.config.client.readTimeout", (Object)0);
            if (timeout != null && timeout > 0) {
                resultFuture.get(timeout.intValue(), TimeUnit.MILLISECONDS);
            } else {
                resultFuture.get();
            }
        }
        catch (ExecutionException ex) {
            Throwable e = ex.getCause() == null ? ex : ex.getCause();
            throw new ProcessingException(e.getMessage(), e);
        }
        catch (Exception ex) {
            throw new ProcessingException(ex.getMessage(), (Throwable)ex);
        }
        Throwable throwable = syncException.get();
        if (throwable == null) {
            return syncResponse.get();
        }
        throw new RuntimeException(throwable);
    }

    public java.util.concurrent.Future<?> apply(final ClientRequest jerseyRequest, final AsyncConnectorCallback jerseyCallback) {
        final CompletableFuture settableFuture = new CompletableFuture();
        final URI requestUri = jerseyRequest.getUri();
        String host = requestUri.getHost();
        int port = requestUri.getPort() != -1 ? requestUri.getPort() : ("https".equals(requestUri.getScheme()) ? 443 : 80);
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    Configuration config;
                    Object proxyUri;
                    ChannelPipeline p = ch.pipeline();
                    if ("https".equals(requestUri.getScheme())) {
                        JdkSslContext jdkSslContext = new JdkSslContext(NettyConnector.this.client.getSslContext(), true, ClientAuth.NONE);
                        p.addLast(new ChannelHandler[]{jdkSslContext.newHandler(ch.alloc())});
                    }
                    if ((proxyUri = (config = jerseyRequest.getConfiguration()).getProperties().get("jersey.config.client.proxy.uri")) != null) {
                        URI u = NettyConnector.getProxyUri(proxyUri);
                        String userName = (String)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.proxy.username", String.class);
                        String password = (String)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.proxy.password", String.class);
                        p.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)new InetSocketAddress(u.getHost(), u.getPort() == -1 ? 8080 : u.getPort()), userName, password)});
                    }
                    p.addLast(new ChannelHandler[]{new HttpClientCodec()});
                    p.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                    p.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                    p.addLast(new ChannelHandler[]{new JerseyClientHandler(NettyConnector.this, jerseyRequest, jerseyCallback, settableFuture)});
                }
            });
            Integer connectTimeout = (Integer)ClientProperties.getValue((Map)jerseyRequest.getConfiguration().getProperties(), (String)"jersey.config.client.connectTimeout", (Object)0);
            if (connectTimeout > 0) {
                b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout);
            }
            final Channel ch = b.connect(host, port).sync().channel();
            GenericFutureListener<Future<? super Void>> closeListener = new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> future) throws Exception {
                    if (!settableFuture.isDone()) {
                        settableFuture.completeExceptionally(new IOException("Channel closed."));
                    }
                }
            };
            ch.closeFuture().addListener((GenericFutureListener)closeListener);
            Object nettyRequest = jerseyRequest.hasEntity() ? new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)jerseyRequest.getMethod()), requestUri.getRawPath()) : new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)jerseyRequest.getMethod()), requestUri.getRawPath());
            for (Map.Entry e : jerseyRequest.getStringHeaders().entrySet()) {
                nettyRequest.headers().add((String)e.getKey(), (Iterable)e.getValue());
            }
            nettyRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)jerseyRequest.getUri().getHost());
            if (jerseyRequest.hasEntity()) {
                if (jerseyRequest.getLengthLong() == -1L) {
                    HttpUtil.setTransferEncodingChunked((HttpMessage)nettyRequest, (boolean)true);
                } else {
                    nettyRequest.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)jerseyRequest.getLengthLong());
                }
            }
            if (jerseyRequest.hasEntity()) {
                ch.writeAndFlush(nettyRequest);
                final JerseyChunkedInput jerseyChunkedInput = new JerseyChunkedInput(ch);
                jerseyRequest.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                    public OutputStream getOutputStream(int contentLength) throws IOException {
                        return jerseyChunkedInput;
                    }
                });
                if (HttpUtil.isTransferEncodingChunked((HttpMessage)nettyRequest)) {
                    ch.write((Object)new HttpChunkedInput((ChunkedInput)jerseyChunkedInput));
                } else {
                    ch.write((Object)jerseyChunkedInput);
                }
                this.executorService.execute(new Runnable((GenericFutureListener)closeListener, jerseyRequest, jerseyCallback, settableFuture){
                    final /* synthetic */ GenericFutureListener val$closeListener;
                    final /* synthetic */ ClientRequest val$jerseyRequest;
                    final /* synthetic */ AsyncConnectorCallback val$jerseyCallback;
                    final /* synthetic */ CompletableFuture val$settableFuture;
                    {
                        this.val$closeListener = genericFutureListener;
                        this.val$jerseyRequest = clientRequest;
                        this.val$jerseyCallback = asyncConnectorCallback;
                        this.val$settableFuture = completableFuture;
                    }

                    @Override
                    public void run() {
                        ch.closeFuture().removeListener(this.val$closeListener);
                        try {
                            this.val$jerseyRequest.writeEntity();
                        }
                        catch (IOException e) {
                            this.val$jerseyCallback.failure((Throwable)e);
                            this.val$settableFuture.completeExceptionally(e);
                        }
                    }
                });
                ch.flush();
            } else {
                ch.closeFuture().removeListener((GenericFutureListener)closeListener);
                ch.writeAndFlush(nettyRequest);
            }
        }
        catch (InterruptedException e) {
            settableFuture.completeExceptionally(e);
            return settableFuture;
        }
        return settableFuture;
    }

    public String getName() {
        return "Netty 4.1.x";
    }

    public void close() {
        this.group.shutdownGracefully();
        this.executorService.shutdown();
    }

    private static URI getProxyUri(Object proxy) {
        if (proxy instanceof URI) {
            return (URI)proxy;
        }
        if (proxy instanceof String) {
            return URI.create((String)proxy);
        }
        throw new ProcessingException(LocalizationMessages.WRONG_PROXY_URI_TYPE("jersey.config.client.proxy.uri"));
    }
}

