/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.netty.connector.JerseyClientHandler;
import org.glassfish.jersey.netty.connector.LocalizationMessages;
import org.glassfish.jersey.netty.connector.internal.JerseyChunkedInput;

class NettyConnector
implements Connector {
    final ExecutorService executorService;
    final EventLoopGroup group;
    final Client client;
    final HashMap<String, ArrayList<Channel>> connections = new HashMap();

    NettyConnector(Client client) {
        Object threadPoolSize = client.getConfiguration().getProperties().get("jersey.config.client.async.threadPoolSize");
        if (threadPoolSize != null && threadPoolSize instanceof Integer && (Integer)threadPoolSize > 0) {
            this.executorService = Executors.newFixedThreadPool((Integer)threadPoolSize);
            this.group = new NioEventLoopGroup(((Integer)threadPoolSize).intValue());
        } else {
            this.executorService = Executors.newCachedThreadPool();
            this.group = new NioEventLoopGroup();
        }
        this.client = client;
    }

    public ClientResponse apply(ClientRequest jerseyRequest) {
        try {
            CompletableFuture<ClientResponse> resultFuture = this.execute(jerseyRequest);
            Integer timeout = (Integer)ClientProperties.getValue((Map)jerseyRequest.getConfiguration().getProperties(), (String)"jersey.config.client.readTimeout", (Object)0);
            return timeout != null && timeout > 0 ? resultFuture.get(timeout.intValue(), TimeUnit.MILLISECONDS) : resultFuture.get();
        }
        catch (ExecutionException ex) {
            Throwable e = ex.getCause() == null ? ex : ex.getCause();
            throw new ProcessingException(e.getMessage(), e);
        }
        catch (Exception ex) {
            throw new ProcessingException(ex.getMessage(), (Throwable)ex);
        }
    }

    public java.util.concurrent.Future<?> apply(ClientRequest jerseyRequest, AsyncConnectorCallback jerseyCallback) {
        return this.execute(jerseyRequest).whenCompleteAsync((r, th) -> {
            if (th == null) {
                jerseyCallback.response(r);
            } else {
                jerseyCallback.failure(th);
            }
        }, (Executor)this.executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<ClientResponse> execute(final ClientRequest jerseyRequest) {
        CompletableFuture<ClientResponse> responseAvailable = new CompletableFuture<ClientResponse>();
        final CompletableFuture responseDone = new CompletableFuture();
        final URI requestUri = jerseyRequest.getUri();
        String host = requestUri.getHost();
        int port = requestUri.getPort() != -1 ? requestUri.getPort() : ("https".equals(requestUri.getScheme()) ? 443 : 80);
        try {
            Channel chan;
            ArrayList<Object> conns;
            String key = requestUri.getScheme() + "://" + host + ":" + port;
            HashMap<String, ArrayList<Channel>> hashMap = this.connections;
            synchronized (hashMap) {
                conns = this.connections.get(key);
                if (conns == null) {
                    conns = new ArrayList(0);
                    this.connections.put(key, conns);
                }
            }
            ArrayList<Channel> arrayList = conns;
            synchronized (arrayList) {
                chan = conns.size() == 0 ? null : (Channel)conns.remove(conns.size() - 1);
            }
            if (chan == null) {
                Bootstrap b = new Bootstrap();
                ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    protected void initChannel(SocketChannel ch) throws Exception {
                        Configuration config;
                        Object proxyUri;
                        ChannelPipeline p = ch.pipeline();
                        if ("https".equals(requestUri.getScheme())) {
                            JdkSslContext jdkSslContext = new JdkSslContext(NettyConnector.this.client.getSslContext(), true, ClientAuth.NONE);
                            p.addLast(new ChannelHandler[]{jdkSslContext.newHandler(ch.alloc())});
                        }
                        if ((proxyUri = (config = jerseyRequest.getConfiguration()).getProperties().get("jersey.config.client.proxy.uri")) != null) {
                            URI u = NettyConnector.getProxyUri(proxyUri);
                            String userName = (String)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.proxy.username", String.class);
                            String password = (String)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.proxy.password", String.class);
                            p.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)new InetSocketAddress(u.getHost(), u.getPort() == -1 ? 8080 : u.getPort()), userName, password)});
                        }
                        p.addLast(new ChannelHandler[]{new HttpClientCodec()});
                        p.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                        p.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                    }
                });
                Integer connectTimeout = (Integer)ClientProperties.getValue((Map)jerseyRequest.getConfiguration().getProperties(), (String)"jersey.config.client.connectTimeout", (Object)0);
                if (connectTimeout > 0) {
                    b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout);
                }
                chan = b.connect(host, port).sync().channel();
            }
            final Channel ch = chan;
            JerseyClientHandler clientHandler = new JerseyClientHandler(jerseyRequest, responseAvailable, responseDone);
            ch.pipeline().addLast(new ChannelHandler[]{clientHandler});
            responseDone.whenComplete((_r, th) -> {
                ch.pipeline().remove((ChannelHandler)clientHandler);
                if (th == null) {
                    HashMap<String, ArrayList<Channel>> hashMap = this.connections;
                    synchronized (hashMap) {
                        ArrayList<Channel> conns1;
                        ArrayList<Channel> arrayList = conns1 = this.connections.get(key);
                        synchronized (arrayList) {
                            conns1.add(ch);
                        }
                    }
                }
                ch.close();
                responseAvailable.completeExceptionally((Throwable)th);
            });
            String pathWithQuery = this.buildPathWithQueryParameters(requestUri);
            Object nettyRequest = jerseyRequest.hasEntity() ? new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)jerseyRequest.getMethod()), pathWithQuery) : new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)jerseyRequest.getMethod()), pathWithQuery);
            for (Map.Entry e : jerseyRequest.getStringHeaders().entrySet()) {
                nettyRequest.headers().add((String)e.getKey(), (Iterable)e.getValue());
            }
            nettyRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)jerseyRequest.getUri().getHost());
            if (jerseyRequest.hasEntity()) {
                GenericFutureListener<Future<? super Void>> closeListener = new GenericFutureListener<Future<? super Void>>(){

                    public void operationComplete(Future<? super Void> future) throws Exception {
                        if (!responseDone.isDone()) {
                            responseDone.completeExceptionally(new IOException("Channel closed."));
                        }
                    }
                };
                ch.closeFuture().addListener((GenericFutureListener)closeListener);
                if (jerseyRequest.getLengthLong() == -1L) {
                    HttpUtil.setTransferEncodingChunked((HttpMessage)nettyRequest, (boolean)true);
                } else {
                    nettyRequest.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)jerseyRequest.getLengthLong());
                }
                ch.writeAndFlush(nettyRequest);
                final JerseyChunkedInput jerseyChunkedInput = new JerseyChunkedInput(ch);
                jerseyRequest.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                    public OutputStream getOutputStream(int contentLength) throws IOException {
                        return jerseyChunkedInput;
                    }
                });
                if (HttpUtil.isTransferEncodingChunked((HttpMessage)nettyRequest)) {
                    ch.write((Object)new HttpChunkedInput((ChunkedInput)jerseyChunkedInput));
                } else {
                    ch.write((Object)jerseyChunkedInput);
                }
                this.executorService.execute(new Runnable((GenericFutureListener)closeListener, jerseyRequest, responseDone){
                    final /* synthetic */ GenericFutureListener val$closeListener;
                    final /* synthetic */ ClientRequest val$jerseyRequest;
                    final /* synthetic */ CompletableFuture val$responseDone;
                    {
                        this.val$closeListener = genericFutureListener;
                        this.val$jerseyRequest = clientRequest;
                        this.val$responseDone = completableFuture;
                    }

                    @Override
                    public void run() {
                        ch.closeFuture().removeListener(this.val$closeListener);
                        try {
                            this.val$jerseyRequest.writeEntity();
                        }
                        catch (IOException e) {
                            this.val$responseDone.completeExceptionally(e);
                        }
                    }
                });
                ch.flush();
            } else {
                ch.writeAndFlush(nettyRequest);
            }
        }
        catch (InterruptedException e) {
            responseDone.completeExceptionally(e);
        }
        return responseAvailable;
    }

    private String buildPathWithQueryParameters(URI requestUri) {
        if (requestUri.getRawQuery() != null) {
            return String.format("%s?%s", requestUri.getRawPath(), requestUri.getRawQuery());
        }
        return requestUri.getRawPath();
    }

    public String getName() {
        return "Netty 4.1.x";
    }

    public void close() {
        this.group.shutdownGracefully();
        this.executorService.shutdown();
    }

    private static URI getProxyUri(Object proxy) {
        if (proxy instanceof URI) {
            return (URI)proxy;
        }
        if (proxy instanceof String) {
            return URI.create((String)proxy);
        }
        throw new ProcessingException(LocalizationMessages.WRONG_PROXY_URI_TYPE("jersey.config.client.proxy.uri"));
    }
}

