/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.LinkedBlockingDeque;

public class NettyInputStream
extends InputStream {
    private final LinkedBlockingDeque<ByteBuf> isList;

    public NettyInputStream(LinkedBlockingDeque<ByteBuf> isList) {
        this.isList = isList;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            ByteBuf take = this.isList.take();
            boolean isReadable = take.isReadable();
            int read = -1;
            if (this.checkEndOfInputOrError(take)) {
                take.release();
                return -1;
            }
            if (isReadable) {
                int readableBytes = take.readableBytes();
                read = Math.min(readableBytes, len);
                take.readBytes(b, off, read);
                if (read < len) {
                    take.release();
                } else {
                    this.isList.addFirst(take);
                }
            } else {
                read = 0;
                take.release();
            }
            return read;
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted.", e);
        }
    }

    @Override
    public int read() throws IOException {
        try {
            ByteBuf take = this.isList.take();
            boolean isReadable = take.isReadable();
            if (this.checkEndOfInputOrError(take)) {
                take.release();
                return -1;
            }
            if (isReadable) {
                return take.readInt();
            }
            take.release();
            return 0;
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted.", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isList != null) {
            while (!this.isList.isEmpty()) {
                try {
                    this.isList.take().release();
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted. Potential ByteBuf Leak.", e);
                }
            }
        }
        super.close();
    }

    @Override
    public int available() throws IOException {
        ByteBuf peek = this.isList.peek();
        if (peek != null && peek.isReadable()) {
            return peek.readableBytes();
        }
        return 0;
    }

    private boolean checkEndOfInputOrError(ByteBuf take) throws IOException {
        return take == Unpooled.EMPTY_BUFFER;
    }
}

