/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.ProcessingException;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.netty.connector.Expect100ContinueConnectorExtension;
import org.glassfish.jersey.netty.connector.LocalizationMessages;

public class JerseyExpectContinueHandler
extends ChannelInboundHandlerAdapter {
    private boolean isExpected;
    private static final List<HttpResponseStatus> statusesToBeConsidered = Arrays.asList(HttpResponseStatus.CONTINUE, HttpResponseStatus.UNAUTHORIZED, HttpResponseStatus.EXPECTATION_FAILED, HttpResponseStatus.METHOD_NOT_ALLOWED, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
    private CompletableFuture<HttpResponseStatus> expectedFuture = new CompletableFuture();

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.isExpected && msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            if (statusesToBeConsidered.contains(response.status())) {
                this.expectedFuture.complete(response.status());
            }
            if (!HttpResponseStatus.CONTINUE.equals((Object)response.status())) {
                ctx.fireChannelRead(msg);
            } else {
                ctx.pipeline().remove(JerseyExpectContinueHandler.class);
            }
        } else {
            if (!this.isExpected) {
                ctx.pipeline().remove(JerseyExpectContinueHandler.class);
            }
            ctx.fireChannelRead(msg);
        }
    }

    CompletableFuture<HttpResponseStatus> processExpect100ContinueRequest(HttpRequest nettyRequest, ClientRequest jerseyRequest, Channel ch, Integer timeout) throws InterruptedException, ExecutionException, TimeoutException {
        Expect100ContinueConnectorExtension expect100ContinueExtension = new Expect100ContinueConnectorExtension();
        DefaultFullHttpRequest nettyRequestHeaders = new DefaultFullHttpRequest(nettyRequest.protocolVersion(), nettyRequest.method(), nettyRequest.uri());
        nettyRequestHeaders.headers().setAll(nettyRequest.headers());
        if (!nettyRequestHeaders.headers().contains((CharSequence)HttpHeaderNames.HOST)) {
            nettyRequestHeaders.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)jerseyRequest.getUri().getHost());
        }
        expect100ContinueExtension.invoke(jerseyRequest, (HttpRequest)nettyRequestHeaders);
        ChannelFuture expect100ContinueFuture = HttpUtil.is100ContinueExpected((HttpMessage)nettyRequestHeaders) ? ch.writeAndFlush((Object)nettyRequestHeaders) : null;
        boolean bl = this.isExpected = expect100ContinueFuture != null;
        if (!this.isExpected) {
            ch.pipeline().remove(JerseyExpectContinueHandler.class);
        } else {
            HttpResponseStatus status = this.expectedFuture.get(timeout.intValue(), TimeUnit.MILLISECONDS);
            this.processExpectationStatus(status);
        }
        return this.expectedFuture;
    }

    private void processExpectationStatus(HttpResponseStatus status) throws TimeoutException {
        if (!statusesToBeConsidered.contains(status)) {
            throw new ProcessingException(LocalizationMessages.UNEXPECTED_VALUE_FOR_EXPECT_100_CONTINUE_STATUSES(status.code()), null);
        }
        if (!this.expectedFuture.isDone() || HttpResponseStatus.EXPECTATION_FAILED.equals((Object)status)) {
            this.isExpected = false;
            throw new TimeoutException();
        }
        if (!HttpResponseStatus.CONTINUE.equals((Object)status)) {
            throw new ProcessingException(LocalizationMessages.UNEXPECTED_VALUE_FOR_EXPECT_100_CONTINUE_STATUSES(status.code()), null);
        }
    }

    boolean isExpected() {
        return this.isExpected;
    }
}

