/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.Version;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.innate.ClientProxy;
import org.glassfish.jersey.client.innate.http.SSLParamConfigurator;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.innate.VirtualThreadUtil;
import org.glassfish.jersey.internal.PropertiesResolver;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.netty.connector.JerseyClientHandler;
import org.glassfish.jersey.netty.connector.JerseyExpectContinueHandler;
import org.glassfish.jersey.netty.connector.LocalizationMessages;
import org.glassfish.jersey.netty.connector.NettyClientProperties;
import org.glassfish.jersey.netty.connector.internal.NettyEntityWriter;

class NettyConnector
implements Connector {
    final ExecutorService executorService;
    final EventLoopGroup group;
    final Client client;
    final HashMap<String, ArrayList<Channel>> connections = new HashMap();
    private static final LazyValue<String> NETTY_VERSION = Values.lazy(() -> {
        String nettyVersion = null;
        try {
            nettyVersion = ((Version)Version.identify().values().iterator().next()).artifactVersion();
        }
        catch (Throwable t) {
            nettyVersion = "4.1.x";
        }
        return "Netty " + nettyVersion;
    });
    private static final String HTTP_KEEPALIVE_STRING = System.getProperty("http.keepAlive");
    private static final Boolean HTTP_KEEPALIVE = HTTP_KEEPALIVE_STRING == null ? Boolean.TRUE : Boolean.parseBoolean(HTTP_KEEPALIVE_STRING);
    private static final int DEFAULT_MAX_POOL_SIZE = 5;
    private static final int MAX_POOL_SIZE = Integer.getInteger("http.maxConnections", 5);
    private static final int DEFAULT_MAX_POOL_IDLE = 60;
    private static final int DEFAULT_MAX_POOL_SIZE_TOTAL = 60;
    private final Integer maxPoolSize;
    private final Integer maxPoolSizeTotal;
    private final Integer maxPoolIdle;
    static final String INACTIVE_POOLED_CONNECTION_HANDLER = "inactive_pooled_connection_handler";
    private static final String PRUNE_INACTIVE_POOL = "prune_inactive_pool";
    private static final String READ_TIMEOUT_HANDLER = "read_timeout_handler";
    private static final String REQUEST_HANDLER = "request_handler";
    private static final String EXPECT_100_CONTINUE_HANDLER = "expect_100_continue_handler";

    NettyConnector(Client client) {
        Configuration configuration = client.getConfiguration();
        Map properties = configuration.getProperties();
        Object threadPoolSize = properties.get("jersey.config.client.async.threadPoolSize");
        if (threadPoolSize != null && threadPoolSize instanceof Integer && (Integer)threadPoolSize > 0) {
            this.executorService = VirtualThreadUtil.withConfig((Configuration)configuration).newFixedThreadPool(((Integer)threadPoolSize).intValue());
            this.group = new NioEventLoopGroup(((Integer)threadPoolSize).intValue());
        } else {
            this.executorService = VirtualThreadUtil.withConfig((Configuration)configuration).newCachedThreadPool();
            this.group = new NioEventLoopGroup();
        }
        this.client = client;
        Object maxPoolSizeTotalProperty = properties.get("jersey.config.client.maxTotalConnections");
        Object maxPoolIdleProperty = properties.get("jersey.config.client.idleConnectionPruneTimeout");
        Object maxPoolSizeProperty = properties.get("jersey.config.client.maxConnections");
        this.maxPoolSizeTotal = maxPoolSizeTotalProperty != null ? (Integer)maxPoolSizeTotalProperty : 60;
        this.maxPoolIdle = maxPoolIdleProperty != null ? (Integer)maxPoolIdleProperty : 60;
        this.maxPoolSize = maxPoolSizeProperty != null ? (Integer)maxPoolSizeProperty : (HTTP_KEEPALIVE != false ? MAX_POOL_SIZE : 5);
        if (this.maxPoolSizeTotal < 0) {
            throw new ProcessingException(LocalizationMessages.WRONG_MAX_POOL_TOTAL(this.maxPoolSizeTotal));
        }
        if (this.maxPoolSize < 0) {
            throw new ProcessingException(LocalizationMessages.WRONG_MAX_POOL_SIZE(this.maxPoolSize));
        }
    }

    public ClientResponse apply(ClientRequest jerseyRequest) {
        try {
            CompletableFuture<ClientResponse> response = new CompletableFuture<ClientResponse>();
            this.execute(jerseyRequest, new HashSet<URI>(), response);
            return response.join();
        }
        catch (CompletionException cex) {
            Throwable t = cex.getCause() == null ? cex : cex.getCause();
            throw new ProcessingException(t.getMessage(), t);
        }
        catch (Exception ex) {
            throw new ProcessingException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Future<?> apply(ClientRequest jerseyRequest, AsyncConnectorCallback jerseyCallback) {
        CompletableFuture<ClientResponse> response = new CompletableFuture<ClientResponse>();
        response.whenCompleteAsync((r, th) -> {
            if (th == null) {
                jerseyCallback.response(r);
            } else {
                jerseyCallback.failure(th);
            }
        }, (Executor)this.executorService);
        this.execute(jerseyRequest, new HashSet<URI>(), response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(final ClientRequest jerseyRequest, Set<URI> redirectUriHistory, CompletableFuture<ClientResponse> responseAvailable) {
        block33: {
            Integer timeout = (Integer)jerseyRequest.resolveProperty("jersey.config.client.readTimeout", (Object)0);
            Integer expect100ContinueTimeout = (Integer)jerseyRequest.resolveProperty("jersey.config.client.request.expect.100.continue.timeout", (Object)NettyClientProperties.DEFAULT_EXPECT_100_CONTINUE_TIMEOUT_VALUE);
            if (timeout == null || timeout < 0) {
                throw new ProcessingException(LocalizationMessages.WRONG_READ_TIMEOUT(timeout));
            }
            final CompletableFuture responseDone = new CompletableFuture();
            final URI requestUri = jerseyRequest.getUri();
            String host = requestUri.getHost();
            int port = requestUri.getPort() != -1 ? requestUri.getPort() : ("https".equals(requestUri.getScheme()) ? 443 : 80);
            try {
                ArrayList<Object> conns;
                final SSLParamConfigurator sslConfig = SSLParamConfigurator.builder().request(jerseyRequest).setSNIAlways(true).setSNIHostName((PropertiesResolver)jerseyRequest).build();
                String key = requestUri.getScheme() + "://" + sslConfig.getSNIHostName() + ":" + port;
                HashMap<String, ArrayList<Channel>> hashMap = this.connections;
                synchronized (hashMap) {
                    conns = this.connections.get(key);
                    if (conns == null) {
                        conns = new ArrayList(0);
                        this.connections.put(key, conns);
                    }
                }
                Channel chan = null;
                ArrayList<Object> arrayList = conns;
                synchronized (arrayList) {
                    while (chan == null && !conns.isEmpty()) {
                        chan = (Channel)conns.remove(conns.size() - 1);
                        try {
                            chan.pipeline().remove(INACTIVE_POOLED_CONNECTION_HANDLER);
                            chan.pipeline().remove(PRUNE_INACTIVE_POOL);
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                        if (chan.isOpen()) continue;
                        chan = null;
                    }
                }
                if (chan == null) {
                    final Integer connectTimeout = (Integer)jerseyRequest.resolveProperty("jersey.config.client.connectTimeout", (Object)0);
                    Bootstrap b = new Bootstrap();
                    Optional proxy = ClientProxy.proxyFromRequest((ClientRequest)jerseyRequest);
                    if (!proxy.isPresent()) {
                        proxy = ClientProxy.proxyFromProperties((URI)requestUri);
                    }
                    proxy.ifPresent(clientProxy -> b.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE));
                    final Optional handlerProxy = proxy;
                    ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                        protected void initChannel(SocketChannel ch) throws Exception {
                            ChannelPipeline p = ch.pipeline();
                            Configuration config = jerseyRequest.getConfiguration();
                            handlerProxy.ifPresent(clientProxy -> {
                                URI u = clientProxy.uri();
                                InetSocketAddress proxyAddr = new InetSocketAddress(u.getHost(), u.getPort() == -1 ? 8080 : u.getPort());
                                ProxyHandler proxy1 = NettyConnector.createProxyHandler(jerseyRequest, proxyAddr, clientProxy.userName(), clientProxy.password(), connectTimeout.intValue());
                                p.addLast(new ChannelHandler[]{proxy1});
                            });
                            if ("https".equals(requestUri.getScheme())) {
                                JdkSslContext jdkSslContext = new JdkSslContext(NettyConnector.this.getSslContext(NettyConnector.this.client, jerseyRequest), true, (Iterable)null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, (ApplicationProtocolConfig)null, ClientAuth.NONE, (String[])null, false);
                                int port = requestUri.getPort();
                                SslHandler sslHandler = jdkSslContext.newHandler(ch.alloc(), sslConfig.getSNIHostName(), port <= 0 ? 443 : port, (Executor)NettyConnector.this.executorService);
                                if (((Boolean)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.tls.enableHostnameVerification", (Object)true)).booleanValue()) {
                                    sslConfig.setEndpointIdentificationAlgorithm(sslHandler.engine());
                                }
                                sslConfig.setSNIServerName(sslHandler.engine());
                                p.addLast(new ChannelHandler[]{sslHandler});
                            }
                            Integer maxHeaderSize = (Integer)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.netty.maxHeaderSize", (Object)NettyClientProperties.DEFAULT_HEADER_SIZE);
                            Integer maxChunkSize = (Integer)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.netty.maxChunkSize", (Object)NettyClientProperties.DEFAULT_CHUNK_SIZE);
                            Integer maxInitialLineLength = (Integer)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.netty.maxInitialLineLength", (Object)NettyClientProperties.DEFAULT_INITIAL_LINE_LENGTH);
                            p.addLast(new ChannelHandler[]{new HttpClientCodec(maxInitialLineLength.intValue(), maxHeaderSize.intValue(), maxChunkSize.intValue())});
                            p.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                            p.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                        }
                    });
                    if (connectTimeout > 0) {
                        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout);
                    }
                    try {
                        chan = b.connect(host, port).sync().channel();
                    }
                    catch (Exception e) {
                        responseAvailable.completeExceptionally(e);
                        return;
                    }
                }
                final Channel ch = chan;
                JerseyClientHandler clientHandler = new JerseyClientHandler(jerseyRequest, responseAvailable, responseDone, redirectUriHistory, this);
                JerseyExpectContinueHandler expect100ContinueHandler = new JerseyExpectContinueHandler();
                ch.pipeline().addLast(READ_TIMEOUT_HANDLER, (ChannelHandler)new IdleStateHandler(0L, 0L, (long)timeout.intValue(), TimeUnit.MILLISECONDS));
                ch.pipeline().addLast(EXPECT_100_CONTINUE_HANDLER, (ChannelHandler)expect100ContinueHandler);
                ch.pipeline().addLast(REQUEST_HANDLER, (ChannelHandler)clientHandler);
                responseDone.whenComplete((_r, th) -> {
                    ch.pipeline().remove(READ_TIMEOUT_HANDLER);
                    ch.pipeline().remove((ChannelHandler)clientHandler);
                    if (th == null) {
                        ch.pipeline().addLast(INACTIVE_POOLED_CONNECTION_HANDLER, (ChannelHandler)new IdleStateHandler(0, 0, this.maxPoolIdle.intValue()));
                        ch.pipeline().addLast(PRUNE_INACTIVE_POOL, (ChannelHandler)new PruneIdlePool(this.connections, key));
                        boolean added = true;
                        HashMap<String, ArrayList<Channel>> hashMap = this.connections;
                        synchronized (hashMap) {
                            ArrayList<Object> conns1 = this.connections.get(key);
                            if (conns1 == null) {
                                conns1 = new ArrayList(1);
                                conns1.add(ch);
                                this.connections.put(key, conns1);
                            } else {
                                ArrayList<Channel> arrayList = conns1;
                                synchronized (arrayList) {
                                    if ((this.maxPoolSizeTotal == 0 || this.connections.size() < this.maxPoolSizeTotal) && conns1.size() < this.maxPoolSize) {
                                        conns1.add(ch);
                                    } else {
                                        added = false;
                                    }
                                }
                            }
                        }
                        if (!added) {
                            ch.close();
                        }
                    } else {
                        ch.close();
                        responseAvailable.completeExceptionally((Throwable)th);
                    }
                });
                String pathWithQuery = this.buildPathWithQueryParameters(requestUri);
                Object nettyRequest = jerseyRequest.hasEntity() ? new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)jerseyRequest.getMethod()), pathWithQuery) : new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)jerseyRequest.getMethod()), pathWithQuery);
                if (!jerseyRequest.hasEntity()) {
                    NettyConnector.setHeaders(jerseyRequest, nettyRequest.headers(), false);
                    if (!nettyRequest.headers().contains((CharSequence)HttpHeaderNames.HOST)) {
                        nettyRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)jerseyRequest.getUri().getHost());
                    }
                }
                if (jerseyRequest.hasEntity()) {
                    NettyEntityWriter entityWriter;
                    GenericFutureListener<io.netty.util.concurrent.Future<? super Void>> closeListener;
                    block32: {
                        closeListener = new GenericFutureListener<io.netty.util.concurrent.Future<? super Void>>(){

                            public void operationComplete(io.netty.util.concurrent.Future<? super Void> future) throws Exception {
                                if (!responseDone.isDone()) {
                                    responseDone.completeExceptionally(new IOException("Channel closed."));
                                }
                            }
                        };
                        ch.closeFuture().addListener((GenericFutureListener)closeListener);
                        entityWriter = NettyEntityWriter.getInstance(jerseyRequest, ch);
                        switch (entityWriter.getType()) {
                            case CHUNKED: {
                                HttpUtil.setTransferEncodingChunked((HttpMessage)nettyRequest, (boolean)true);
                                break;
                            }
                            case PRESET: {
                                nettyRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)jerseyRequest.getLengthLong());
                            }
                        }
                        try {
                            expect100ContinueHandler.processExpect100ContinueRequest((HttpRequest)nettyRequest, jerseyRequest, ch, expect100ContinueTimeout);
                        }
                        catch (ExecutionException e) {
                            responseDone.completeExceptionally(e);
                        }
                        catch (TimeoutException e) {
                            if (ch.pipeline().context(JerseyExpectContinueHandler.class) == null) break block32;
                            ch.pipeline().remove(EXPECT_100_CONTINUE_HANDLER);
                        }
                    }
                    CountDownLatch headersSet = new CountDownLatch(1);
                    CountDownLatch contentLengthSet = new CountDownLatch(1);
                    jerseyRequest.setStreamProvider(new OutboundMessageContext.StreamProvider((HttpRequest)nettyRequest, headersSet, entityWriter){
                        final /* synthetic */ HttpRequest val$nettyRequest;
                        final /* synthetic */ CountDownLatch val$headersSet;
                        final /* synthetic */ NettyEntityWriter val$entityWriter;
                        {
                            this.val$nettyRequest = httpRequest;
                            this.val$headersSet = countDownLatch;
                            this.val$entityWriter = nettyEntityWriter;
                        }

                        public OutputStream getOutputStream(int contentLength) throws IOException {
                            NettyConnector.replaceHeaders(jerseyRequest, this.val$nettyRequest.headers());
                            if (!this.val$nettyRequest.headers().contains((CharSequence)HttpHeaderNames.HOST)) {
                                this.val$nettyRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)jerseyRequest.getUri().getHost());
                            }
                            this.val$headersSet.countDown();
                            return this.val$entityWriter.getOutputStream();
                        }
                    });
                    this.executorService.execute(new Runnable((GenericFutureListener)closeListener, jerseyRequest, entityWriter, (HttpRequest)nettyRequest, contentLengthSet, responseDone){
                        final /* synthetic */ GenericFutureListener val$closeListener;
                        final /* synthetic */ ClientRequest val$jerseyRequest;
                        final /* synthetic */ NettyEntityWriter val$entityWriter;
                        final /* synthetic */ HttpRequest val$nettyRequest;
                        final /* synthetic */ CountDownLatch val$contentLengthSet;
                        final /* synthetic */ CompletableFuture val$responseDone;
                        {
                            this.val$closeListener = genericFutureListener;
                            this.val$jerseyRequest = clientRequest;
                            this.val$entityWriter = nettyEntityWriter;
                            this.val$nettyRequest = httpRequest;
                            this.val$contentLengthSet = countDownLatch;
                            this.val$responseDone = completableFuture;
                        }

                        @Override
                        public void run() {
                            ch.closeFuture().removeListener(this.val$closeListener);
                            try {
                                this.val$jerseyRequest.writeEntity();
                                if (this.val$entityWriter.getType() == NettyEntityWriter.Type.DELAYED) {
                                    this.val$nettyRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)this.val$entityWriter.getLength());
                                    this.val$contentLengthSet.countDown();
                                }
                            }
                            catch (IOException e) {
                                this.val$responseDone.completeExceptionally(e);
                            }
                        }
                    });
                    headersSet.await();
                    if (!expect100ContinueHandler.isExpected()) {
                        entityWriter.writeAndFlush(nettyRequest);
                    }
                    if (HttpUtil.isTransferEncodingChunked((HttpMessage)nettyRequest)) {
                        entityWriter.write(new HttpChunkedInput(entityWriter.getChunkedInput()));
                    } else {
                        entityWriter.write(entityWriter.getChunkedInput());
                    }
                    if (entityWriter.getType() == NettyEntityWriter.Type.DELAYED) {
                        contentLengthSet.await();
                    }
                    entityWriter.flush();
                    break block33;
                }
                ch.writeAndFlush(nettyRequest);
            }
            catch (IOException | InterruptedException e) {
                responseDone.completeExceptionally(e);
            }
        }
    }

    private SSLContext getSslContext(Client client, ClientRequest request) {
        Supplier supplier = (Supplier)request.resolveProperty("jersey.config.client.ssl.context.supplier", Supplier.class);
        return supplier == null ? client.getSslContext() : (SSLContext)supplier.get();
    }

    private String buildPathWithQueryParameters(URI requestUri) {
        if (requestUri.getRawQuery() != null) {
            return String.format("%s?%s", requestUri.getRawPath(), requestUri.getRawQuery());
        }
        return requestUri.getRawPath();
    }

    public String getName() {
        return (String)NETTY_VERSION.get();
    }

    public void close() {
        this.group.shutdownGracefully();
        this.executorService.shutdown();
    }

    private static ProxyHandler createProxyHandler(ClientRequest jerseyRequest, SocketAddress proxyAddr, String userName, String password, long connectTimeout) {
        HttpProxyHandler proxy;
        Boolean filter = (Boolean)jerseyRequest.resolveProperty("jersey.config.client.filter.headers.proxy", (Object)Boolean.TRUE);
        HttpHeaders httpHeaders = NettyConnector.setHeaders(jerseyRequest, (HttpHeaders)new DefaultHttpHeaders(), Boolean.TRUE.equals(filter));
        HttpProxyHandler httpProxyHandler = proxy = userName == null ? new HttpProxyHandler(proxyAddr, httpHeaders) : new HttpProxyHandler(proxyAddr, userName, password, httpHeaders);
        if (connectTimeout > 0L) {
            proxy.setConnectTimeoutMillis(connectTimeout);
        }
        return proxy;
    }

    private static HttpHeaders setHeaders(ClientRequest jerseyRequest, HttpHeaders headers, boolean proxyOnly) {
        for (Map.Entry e : jerseyRequest.getStringHeaders().entrySet()) {
            String key = (String)e.getKey();
            if (proxyOnly && !JerseyClientHandler.ProxyHeaders.INSTANCE.test(key) && !NettyConnector.additionalProxyHeadersToKeep(key)) continue;
            headers.add(key, (Iterable)e.getValue());
        }
        return headers;
    }

    private static HttpHeaders replaceHeaders(ClientRequest jerseyRequest, HttpHeaders headers) {
        for (Map.Entry e : jerseyRequest.getStringHeaders().entrySet()) {
            headers.set((String)e.getKey(), (Iterable)e.getValue());
        }
        return headers;
    }

    private static boolean additionalProxyHeadersToKeep(String key) {
        return key.length() > 2 && (key.charAt(0) == 'x' || key.charAt(0) == 'X') && key.charAt(1) == '-';
    }

    protected static class PruneIdlePool
    extends ChannelDuplexHandler {
        HashMap<String, ArrayList<Channel>> connections;
        String key;

        public PruneIdlePool(HashMap<String, ArrayList<Channel>> connections, String key) {
            this.connections = connections;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof IdleStateEvent) {
                IdleStateEvent e = (IdleStateEvent)evt;
                if (e.state() == IdleState.ALL_IDLE) {
                    ctx.close();
                    HashMap<String, ArrayList<Channel>> hashMap = this.connections;
                    synchronized (hashMap) {
                        ArrayList<Channel> chans;
                        ArrayList<Channel> arrayList = chans = this.connections.get(this.key);
                        synchronized (arrayList) {
                            chans.remove(ctx.channel());
                            if (chans.isEmpty()) {
                                this.connections.remove(this.key);
                            }
                        }
                    }
                }
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }
    }
}

