/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.ProcessingException;
import org.glassfish.jersey.netty.connector.LocalizationMessages;

public class JerseyExpectContinueHandler
extends ChannelInboundHandlerAdapter {
    private ExpectationState currentState = ExpectationState.IDLE;
    private static final List<HttpResponseStatus> finalErrorStatuses = Arrays.asList(HttpResponseStatus.UNAUTHORIZED, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
    private static final List<HttpResponseStatus> reSendErrorStatuses = Arrays.asList(HttpResponseStatus.METHOD_NOT_ALLOWED, HttpResponseStatus.EXPECTATION_FAILED);
    private static final List<HttpResponseStatus> statusesToBeConsidered = new ArrayList<HttpResponseStatus>(reSendErrorStatuses);
    private HttpResponseStatus status = null;
    private CountDownLatch latch = null;
    private boolean propagateLastMessage = false;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.checkExpectResponse(msg) || this.checkInvalidExpect(msg)) {
            this.currentState = ExpectationState.AWAITING;
        }
        switch (this.currentState) {
            case AWAITING: {
                HttpResponse response = (HttpResponse)msg;
                this.status = response.status();
                boolean handshakeDone = this.processErrorStatuses(this.status) || msg instanceof FullHttpMessage;
                this.currentState = handshakeDone ? ExpectationState.IDLE : ExpectationState.FINISHING;
                this.processLatch();
                return;
            }
            case FINISHING: {
                if (msg instanceof LastHttpContent) {
                    this.currentState = ExpectationState.IDLE;
                    if (this.propagateLastMessage) {
                        this.propagateLastMessage = false;
                        ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                    }
                }
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }

    private boolean checkExpectResponse(Object msg) {
        if (this.currentState == ExpectationState.IDLE && this.latch != null && msg instanceof HttpResponse) {
            return statusesToBeConsidered.contains(((HttpResponse)msg).status());
        }
        return false;
    }

    private boolean checkInvalidExpect(Object msg) {
        return ExpectationState.IDLE.equals((Object)this.currentState) && msg instanceof HttpResponse && (HttpResponseStatus.CONTINUE.equals((Object)((HttpResponse)msg).status()) || reSendErrorStatuses.contains(((HttpResponse)msg).status()));
    }

    boolean processErrorStatuses(HttpResponseStatus status) {
        if (reSendErrorStatuses.contains(status)) {
            this.propagateLastMessage = true;
        }
        return finalErrorStatuses.contains(status);
    }

    void processExpectationStatus() throws TimeoutException, IOException {
        if (this.status == null) {
            throw new TimeoutException();
        }
        if (!statusesToBeConsidered.contains(this.status)) {
            throw new ProcessingException(LocalizationMessages.UNEXPECTED_VALUE_FOR_EXPECT_100_CONTINUE_STATUSES(this.status.code()), null);
        }
        if (finalErrorStatuses.contains(this.status)) {
            throw new IOException(LocalizationMessages.EXPECT_100_CONTINUE_FAILED_REQUEST_FAILED(), null);
        }
        if (reSendErrorStatuses.contains(this.status)) {
            throw new TimeoutException(LocalizationMessages.EXPECT_100_CONTINUE_FAILED_REQUEST_SHOULD_BE_RESENT());
        }
    }

    void resetHandler() {
        this.latch = null;
    }

    void attachCountDownLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    private void processLatch() {
        if (this.latch != null) {
            this.latch.countDown();
        }
    }

    static {
        statusesToBeConsidered.addAll(finalErrorStatuses);
        statusesToBeConsidered.add(HttpResponseStatus.CONTINUE);
    }

    private static enum ExpectationState {
        AWAITING,
        FINISHING,
        IDLE;

    }
}

