/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.net.ProtocolException;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.internal.ConnectorExtension;

class Expect100ContinueConnectorExtension
implements ConnectorExtension<HttpRequest, IOException> {
    private static final String EXCEPTION_MESSAGE = "Server rejected operation";

    Expect100ContinueConnectorExtension() {
    }

    public void invoke(ClientRequest request, HttpRequest extensionParam) {
        boolean allowStreaming;
        long length = request.getLengthLong();
        RequestEntityProcessing entityProcessing = (RequestEntityProcessing)request.resolveProperty("jersey.config.client.request.entity.processing", RequestEntityProcessing.class);
        Boolean expectContinueActivated = (Boolean)request.resolveProperty("jersey.config.client.request.expect.100.continue.processing", Boolean.class);
        Long expectContinueSizeThreshold = (Long)request.resolveProperty("jersey.config.client.request.expect.100.continue.threshold.size", (Object)ClientProperties.DEFAULT_EXPECT_100_CONTINUE_THRESHOLD_SIZE);
        boolean bl = allowStreaming = length > expectContinueSizeThreshold || entityProcessing == RequestEntityProcessing.CHUNKED;
        if (extensionParam.protocolVersion().equals((Object)HttpVersion.HTTP_1_0) || !Boolean.TRUE.equals(expectContinueActivated) || !request.hasEntity() || !allowStreaming) {
            return;
        }
        extensionParam.headers().add((CharSequence)HttpHeaderNames.EXPECT, (Object)HttpHeaderValues.CONTINUE);
    }

    public void postConnectionProcessing(HttpRequest extensionParam) {
    }

    public boolean handleException(ClientRequest request, HttpRequest extensionParam, IOException ex) {
        Boolean expectContinueActivated = (Boolean)request.resolveProperty("jersey.config.client.request.expect.100.continue.processing", (Object)Boolean.FALSE);
        return expectContinueActivated != false && ex instanceof ProtocolException && ex.getMessage().equals(EXCEPTION_MESSAGE);
    }
}

