/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.IdleStateEvent;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.http.ResponseStatus;
import org.glassfish.jersey.netty.connector.LocalizationMessages;
import org.glassfish.jersey.netty.connector.NettyConnector;
import org.glassfish.jersey.netty.connector.internal.NettyInputStream;
import org.glassfish.jersey.netty.connector.internal.RedirectException;
import org.glassfish.jersey.uri.internal.JerseyUriBuilder;

class JerseyClientHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final int DEFAULT_MAX_REDIRECTS = 5;
    private final Set<URI> redirectUriHistory;
    private final ClientRequest jerseyRequest;
    private final CompletableFuture<ClientResponse> responseAvailable;
    private final CompletableFuture<?> responseDone;
    private final boolean followRedirects;
    private final int maxRedirects;
    private final NettyConnector connector;
    private NettyInputStream nis;
    private ClientResponse jerseyResponse;
    private boolean readTimedOut;

    JerseyClientHandler(ClientRequest request, CompletableFuture<ClientResponse> responseAvailable, CompletableFuture<?> responseDone, Set<URI> redirectUriHistory, NettyConnector connector) {
        this.redirectUriHistory = redirectUriHistory;
        this.jerseyRequest = request;
        this.responseAvailable = responseAvailable;
        this.responseDone = responseDone;
        this.followRedirects = (Boolean)this.jerseyRequest.resolveProperty("jersey.config.client.followRedirects", (Object)true);
        this.maxRedirects = (Integer)this.jerseyRequest.resolveProperty("jersey.config.client.NettyConnectorProvider.maxRedirects", (Object)5);
        this.connector = connector;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        this.notifyResponse();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.readTimedOut) {
            this.responseDone.completeExceptionally(new TimeoutException("Stream closed: read timeout"));
        } else if (this.jerseyRequest.isCancelled()) {
            this.responseDone.completeExceptionally(new CancellationException());
        } else {
            this.responseDone.completeExceptionally(new IOException("Stream closed"));
        }
    }

    protected void notifyResponse() {
        block10: {
            if (this.jerseyResponse != null) {
                ClientResponse cr = this.jerseyResponse;
                this.jerseyResponse = null;
                int responseStatus = cr.getStatus();
                if (this.followRedirects && (responseStatus == ResponseStatus.Redirect3xx.MOVED_PERMANENTLY_301.getStatusCode() || responseStatus == ResponseStatus.Redirect3xx.FOUND_302.getStatusCode() || responseStatus == ResponseStatus.Redirect3xx.SEE_OTHER_303.getStatusCode() || responseStatus == ResponseStatus.Redirect3xx.TEMPORARY_REDIRECT_307.getStatusCode() || responseStatus == ResponseStatus.Redirect3xx.PERMANENT_REDIRECT_308.getStatusCode())) {
                    String location = cr.getHeaderString("Location");
                    if (location == null || location.isEmpty()) {
                        this.responseAvailable.completeExceptionally(new RedirectException(LocalizationMessages.REDIRECT_NO_LOCATION()));
                    } else {
                        try {
                            boolean alreadyRequested;
                            URI newUri = URI.create(location);
                            if (!newUri.isAbsolute()) {
                                URI originalUri = this.jerseyRequest.getUri();
                                newUri = new JerseyUriBuilder().scheme(originalUri.getScheme()).userInfo(originalUri.getUserInfo()).host(originalUri.getHost()).port(originalUri.getPort()).uri(location).build(new Object[0]);
                            }
                            boolean bl = alreadyRequested = !this.redirectUriHistory.add(newUri);
                            if (alreadyRequested) {
                                this.responseAvailable.completeExceptionally(new RedirectException(LocalizationMessages.REDIRECT_INFINITE_LOOP()));
                                break block10;
                            }
                            if (this.redirectUriHistory.size() > this.maxRedirects) {
                                this.responseAvailable.completeExceptionally(new RedirectException(LocalizationMessages.REDIRECT_LIMIT_REACHED(this.maxRedirects)));
                                break block10;
                            }
                            ClientRequest newReq = new ClientRequest(this.jerseyRequest);
                            newReq.setUri(newUri);
                            this.restrictRedirectRequest(newReq, cr);
                            this.connector.execute(newReq, this.redirectUriHistory, this.responseAvailable);
                        }
                        catch (IllegalArgumentException e) {
                            this.responseAvailable.completeExceptionally(new RedirectException(LocalizationMessages.REDIRECT_ERROR_DETERMINING_LOCATION(location)));
                        }
                    }
                } else {
                    this.responseAvailable.complete(cr);
                }
            }
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (this.jerseyRequest.isCancelled()) {
            this.responseAvailable.completeExceptionally(new CancellationException());
            return;
        }
        if (msg instanceof HttpResponse) {
            final HttpResponse response = (HttpResponse)msg;
            this.jerseyResponse = new ClientResponse(new Response.StatusType(){

                public int getStatusCode() {
                    return response.status().code();
                }

                public Response.Status.Family getFamily() {
                    return Response.Status.Family.familyOf((int)response.status().code());
                }

                public String getReasonPhrase() {
                    return response.status().reasonPhrase();
                }
            }, this.jerseyRequest);
            for (Map.Entry entry : response.headers().entries()) {
                this.jerseyResponse.getHeaders().add(entry.getKey(), entry.getValue());
            }
            this.nis = new NettyInputStream();
            this.responseDone.whenComplete((_r, th) -> this.nis.complete((Throwable)th));
            this.jerseyResponse.setEntityStream((InputStream)this.nis);
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ByteBuf content = httpContent.content();
            if (content.isReadable()) {
                content.retain();
                if (this.nis == null) {
                    this.nis = new NettyInputStream();
                }
                this.nis.publish(content);
            }
            if (msg instanceof LastHttpContent) {
                this.responseDone.complete(null);
                this.notifyResponse();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.responseDone.completeExceptionally(cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            this.readTimedOut = true;
            ctx.close();
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    private void restrictRedirectRequest(ClientRequest newRequest, ClientResponse response) {
        MultivaluedMap headers = newRequest.getHeaders();
        Boolean keepMethod = (Boolean)newRequest.resolveProperty("jersey.config.client.redirect.preserve.method", (Object)Boolean.TRUE);
        if (Boolean.FALSE.equals(keepMethod) && newRequest.getMethod().equals("POST")) {
            switch (response.getStatus()) {
                case 301: 
                case 302: {
                    this.removeContentHeaders((MultivaluedMap<String, Object>)headers);
                    newRequest.setMethod("GET");
                    newRequest.setEntity(null);
                }
            }
        }
        Iterator it = headers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            if (!ProxyHeaders.INSTANCE.test((String)entry.getKey())) continue;
            it.remove();
        }
        headers.remove((Object)"If-Match");
        headers.remove((Object)"If-None-Match");
        headers.remove((Object)"If-Modified-Since");
        headers.remove((Object)"If-Unmodified-Since");
        headers.remove((Object)"Authorization");
        headers.remove((Object)"Referer");
        headers.remove((Object)"Cookie");
    }

    private void removeContentHeaders(MultivaluedMap<String, Object> headers) {
        Iterator it = headers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String lowName = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
            if (!lowName.startsWith("content-")) continue;
            it.remove();
        }
        headers.remove((Object)"Last-Modified");
        headers.remove((Object)"Transfer-Encoding");
    }

    static class ProxyHeaders
    implements Predicate<String> {
        static final ProxyHeaders INSTANCE = new ProxyHeaders();
        private static final String HOST = "Host".toLowerCase(Locale.ROOT);
        private static final String FORWARDED = "Forwarded".toLowerCase(Locale.ROOT);

        ProxyHeaders() {
        }

        @Override
        public boolean test(String headerName) {
            String lowName = headerName.toLowerCase(Locale.ROOT);
            return lowName.startsWith("proxy-") || lowName.equals(HOST) || lowName.equals(FORWARDED);
        }
    }
}

