
package org.glassfish.jersey.netty.connector;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "org.glassfish.jersey.netty.connector.localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableWRONG_MAX_POOL_IDLE(Object arg0) {
        return MESSAGE_FACTORY.getMessage("wrong.max.pool.idle", arg0);
    }

    /**
     * Unexpected ("{0}") maximum number of idle seconds.
     * 
     */
    public static String WRONG_MAX_POOL_IDLE(Object arg0) {
        return LOCALIZER.localize(localizableWRONG_MAX_POOL_IDLE(arg0));
    }

    public static Localizable localizableWRONG_PROXY_URI_TYPE(Object arg0) {
        return MESSAGE_FACTORY.getMessage("wrong.proxy.uri.type", arg0);
    }

    /**
     * The proxy URI ("{0}") property MUST be an instance of String or URI.
     * 
     */
    public static String WRONG_PROXY_URI_TYPE(Object arg0) {
        return LOCALIZER.localize(localizableWRONG_PROXY_URI_TYPE(arg0));
    }

    public static Localizable localizableWRONG_MAX_POOL_TOTAL(Object arg0) {
        return MESSAGE_FACTORY.getMessage("wrong.max.pool.total", arg0);
    }

    /**
     * Unexpected ("{0}") maximum number of connections total.
     * 
     */
    public static String WRONG_MAX_POOL_TOTAL(Object arg0) {
        return LOCALIZER.localize(localizableWRONG_MAX_POOL_TOTAL(arg0));
    }

    public static Localizable localizableWRONG_READ_TIMEOUT(Object arg0) {
        return MESSAGE_FACTORY.getMessage("wrong.read.timeout", arg0);
    }

    /**
     * Unexpected ("{0}") READ_TIMEOUT.
     * 
     */
    public static String WRONG_READ_TIMEOUT(Object arg0) {
        return LOCALIZER.localize(localizableWRONG_READ_TIMEOUT(arg0));
    }

    public static Localizable localizableWRONG_MAX_POOL_SIZE(Object arg0) {
        return MESSAGE_FACTORY.getMessage("wrong.max.pool.size", arg0);
    }

    /**
     * Unexpected ("{0}") maximum number of connections per destination.
     * 
     */
    public static String WRONG_MAX_POOL_SIZE(Object arg0) {
        return LOCALIZER.localize(localizableWRONG_MAX_POOL_SIZE(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
