/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.IdleStateEvent;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.netty.connector.internal.NettyInputStream;

class JerseyClientHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private final ClientRequest jerseyRequest;
    private final CompletableFuture<ClientResponse> responseAvailable;
    private final CompletableFuture<?> responseDone;
    private NettyInputStream nis;
    private ClientResponse jerseyResponse;
    private boolean readTimedOut;

    JerseyClientHandler(ClientRequest request, CompletableFuture<ClientResponse> responseAvailable, CompletableFuture<?> responseDone) {
        this.jerseyRequest = request;
        this.responseAvailable = responseAvailable;
        this.responseDone = responseDone;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        this.notifyResponse();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.readTimedOut) {
            this.responseDone.completeExceptionally(new TimeoutException("Stream closed: read timeout"));
        } else {
            this.responseDone.completeExceptionally(new IOException("Stream closed"));
        }
    }

    protected void notifyResponse() {
        if (this.jerseyResponse != null) {
            ClientResponse cr = this.jerseyResponse;
            this.jerseyResponse = null;
            this.responseAvailable.complete(cr);
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpResponse) {
            final HttpResponse response = (HttpResponse)msg;
            this.jerseyResponse = new ClientResponse(new Response.StatusType(){

                public int getStatusCode() {
                    return response.status().code();
                }

                public Response.Status.Family getFamily() {
                    return Response.Status.Family.familyOf((int)response.status().code());
                }

                public String getReasonPhrase() {
                    return response.status().reasonPhrase();
                }
            }, this.jerseyRequest);
            for (Map.Entry entry : response.headers().entries()) {
                this.jerseyResponse.getHeaders().add((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
            }
            if (response.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && HttpUtil.getContentLength((HttpMessage)response) > 0L || HttpUtil.isTransferEncodingChunked((HttpMessage)response)) {
                this.nis = new NettyInputStream();
                this.responseDone.whenComplete((_r, th) -> this.nis.complete((Throwable)th));
                this.jerseyResponse.setEntityStream((InputStream)this.nis);
            } else {
                this.jerseyResponse.setEntityStream(new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return -1;
                    }
                });
            }
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ByteBuf content = httpContent.content();
            if (content.isReadable()) {
                content.retain();
                this.nis.publish(content);
            }
            if (msg instanceof LastHttpContent) {
                this.responseDone.complete(null);
                this.notifyResponse();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.responseDone.completeExceptionally(cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            this.readTimedOut = true;
            ctx.close();
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

