/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.IdleStateEvent;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.netty.connector.LocalizationMessages;
import org.glassfish.jersey.netty.connector.NettyConnector;
import org.glassfish.jersey.netty.connector.internal.NettyInputStream;
import org.glassfish.jersey.netty.connector.internal.RedirectException;

class JerseyClientHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final int DEFAULT_MAX_REDIRECTS = 5;
    private final Set<URI> redirectUriHistory;
    private final ClientRequest jerseyRequest;
    private final CompletableFuture<ClientResponse> responseAvailable;
    private final CompletableFuture<?> responseDone;
    private final boolean followRedirects;
    private final int maxRedirects;
    private final NettyConnector connector;
    private NettyInputStream nis;
    private ClientResponse jerseyResponse;
    private boolean readTimedOut;

    JerseyClientHandler(ClientRequest request, CompletableFuture<ClientResponse> responseAvailable, CompletableFuture<?> responseDone, Set<URI> redirectUriHistory, NettyConnector connector) {
        this.redirectUriHistory = redirectUriHistory;
        this.jerseyRequest = request;
        this.responseAvailable = responseAvailable;
        this.responseDone = responseDone;
        this.followRedirects = (Boolean)this.jerseyRequest.resolveProperty("jersey.config.client.followRedirects", (Object)true);
        this.maxRedirects = (Integer)this.jerseyRequest.resolveProperty("jersey.config.client.NettyConnectorProvider.maxRedirects", (Object)5);
        this.connector = connector;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        this.notifyResponse();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.readTimedOut) {
            this.responseDone.completeExceptionally(new TimeoutException("Stream closed: read timeout"));
        } else {
            this.responseDone.completeExceptionally(new IOException("Stream closed"));
        }
    }

    protected void notifyResponse() {
        block9: {
            if (this.jerseyResponse != null) {
                ClientResponse cr = this.jerseyResponse;
                this.jerseyResponse = null;
                int responseStatus = cr.getStatus();
                if (this.followRedirects && (responseStatus == HttpResponseStatus.MOVED_PERMANENTLY.code() || responseStatus == HttpResponseStatus.FOUND.code() || responseStatus == HttpResponseStatus.SEE_OTHER.code() || responseStatus == HttpResponseStatus.TEMPORARY_REDIRECT.code() || responseStatus == HttpResponseStatus.PERMANENT_REDIRECT.code())) {
                    String location = cr.getHeaderString("Location");
                    if (location == null || location.isEmpty()) {
                        this.responseAvailable.completeExceptionally(new RedirectException(LocalizationMessages.REDIRECT_NO_LOCATION()));
                    } else {
                        try {
                            boolean alreadyRequested;
                            URI newUri = URI.create(location);
                            boolean bl = alreadyRequested = !this.redirectUriHistory.add(newUri);
                            if (alreadyRequested) {
                                this.responseAvailable.completeExceptionally(new RedirectException(LocalizationMessages.REDIRECT_INFINITE_LOOP()));
                                break block9;
                            }
                            if (this.redirectUriHistory.size() > this.maxRedirects) {
                                this.responseAvailable.completeExceptionally(new RedirectException(LocalizationMessages.REDIRECT_LIMIT_REACHED(this.maxRedirects)));
                                break block9;
                            }
                            ClientRequest newReq = new ClientRequest(this.jerseyRequest);
                            newReq.setUri(newUri);
                            this.connector.execute(newReq, this.redirectUriHistory, this.responseAvailable);
                        }
                        catch (IllegalArgumentException e) {
                            this.responseAvailable.completeExceptionally(new RedirectException(LocalizationMessages.REDIRECT_ERROR_DETERMINING_LOCATION(location)));
                        }
                    }
                } else {
                    this.responseAvailable.complete(cr);
                }
            }
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpResponse) {
            final HttpResponse response = (HttpResponse)msg;
            this.jerseyResponse = new ClientResponse(new Response.StatusType(){

                public int getStatusCode() {
                    return response.status().code();
                }

                public Response.Status.Family getFamily() {
                    return Response.Status.Family.familyOf((int)response.status().code());
                }

                public String getReasonPhrase() {
                    return response.status().reasonPhrase();
                }
            }, this.jerseyRequest);
            for (Map.Entry entry : response.headers().entries()) {
                this.jerseyResponse.getHeaders().add((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
            }
            if (response.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && HttpUtil.getContentLength((HttpMessage)response) > 0L || HttpUtil.isTransferEncodingChunked((HttpMessage)response)) {
                this.nis = new NettyInputStream();
                this.responseDone.whenComplete((_r, th) -> this.nis.complete((Throwable)th));
                this.jerseyResponse.setEntityStream((InputStream)this.nis);
            } else {
                this.jerseyResponse.setEntityStream(new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return -1;
                    }
                });
            }
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ByteBuf content = httpContent.content();
            if (content.isReadable()) {
                content.retain();
                this.nis.publish(content);
            }
            if (msg instanceof LastHttpContent) {
                this.responseDone.complete(null);
                this.notifyResponse();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.responseDone.completeExceptionally(cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            this.readTimedOut = true;
            ctx.close();
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

