
package org.glassfish.jersey.netty.connector;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private static final String BUNDLE_NAME = "org.glassfish.jersey.netty.connector.localization";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private LocalizationMessages() {
    }

    public static Localizable localizableWRONG_MAX_POOL_IDLE(Object arg0) {
        return MESSAGE_FACTORY.getMessage("wrong.max.pool.idle", arg0);
    }

    /**
     * Unexpected ("{0}") maximum number of idle seconds.
     * 
     */
    public static String WRONG_MAX_POOL_IDLE(Object arg0) {
        return LOCALIZER.localize(localizableWRONG_MAX_POOL_IDLE(arg0));
    }

    public static Localizable localizableREDIRECT_NO_LOCATION() {
        return MESSAGE_FACTORY.getMessage("redirect.no.location");
    }

    /**
     * "Received redirect that does not contain a location or the location is empty."
     * 
     */
    public static String REDIRECT_NO_LOCATION() {
        return LOCALIZER.localize(localizableREDIRECT_NO_LOCATION());
    }

    public static Localizable localizableWRONG_MAX_POOL_TOTAL(Object arg0) {
        return MESSAGE_FACTORY.getMessage("wrong.max.pool.total", arg0);
    }

    /**
     * Unexpected ("{0}") maximum number of connections total.
     * 
     */
    public static String WRONG_MAX_POOL_TOTAL(Object arg0) {
        return LOCALIZER.localize(localizableWRONG_MAX_POOL_TOTAL(arg0));
    }

    public static Localizable localizableREDIRECT_ERROR_DETERMINING_LOCATION(Object arg0) {
        return MESSAGE_FACTORY.getMessage("redirect.error.determining.location", arg0);
    }

    /**
     * "Error determining redirect location: ({0})."
     * 
     */
    public static String REDIRECT_ERROR_DETERMINING_LOCATION(Object arg0) {
        return LOCALIZER.localize(localizableREDIRECT_ERROR_DETERMINING_LOCATION(arg0));
    }

    public static Localizable localizableREDIRECT_LIMIT_REACHED(Object arg0) {
        return MESSAGE_FACTORY.getMessage("redirect.limit.reached", arg0);
    }

    /**
     * "Max chained redirect limit ({0}) exceeded."
     * 
     */
    public static String REDIRECT_LIMIT_REACHED(Object arg0) {
        return LOCALIZER.localize(localizableREDIRECT_LIMIT_REACHED(arg0));
    }

    public static Localizable localizableWRONG_READ_TIMEOUT(Object arg0) {
        return MESSAGE_FACTORY.getMessage("wrong.read.timeout", arg0);
    }

    /**
     * Unexpected ("{0}") READ_TIMEOUT.
     * 
     */
    public static String WRONG_READ_TIMEOUT(Object arg0) {
        return LOCALIZER.localize(localizableWRONG_READ_TIMEOUT(arg0));
    }

    public static Localizable localizableWRONG_MAX_POOL_SIZE(Object arg0) {
        return MESSAGE_FACTORY.getMessage("wrong.max.pool.size", arg0);
    }

    /**
     * Unexpected ("{0}") maximum number of connections per destination.
     * 
     */
    public static String WRONG_MAX_POOL_SIZE(Object arg0) {
        return LOCALIZER.localize(localizableWRONG_MAX_POOL_SIZE(arg0));
    }

    public static Localizable localizableREDIRECT_INFINITE_LOOP() {
        return MESSAGE_FACTORY.getMessage("redirect.infinite.loop");
    }

    /**
     * "Infinite loop in chained redirects detected."
     * 
     */
    public static String REDIRECT_INFINITE_LOOP() {
        return LOCALIZER.localize(localizableREDIRECT_INFINITE_LOOP());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
