/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector.internal;

import io.netty.channel.Channel;
import io.netty.handler.stream.ChunkedInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.netty.connector.internal.JerseyChunkedInput;

public interface NettyEntityWriter {
    public void write(Object var1);

    public void writeAndFlush(Object var1);

    public void flush() throws IOException;

    public ChunkedInput getChunkedInput();

    public OutputStream getOutputStream();

    public long getLength();

    public Type getType();

    public static NettyEntityWriter getInstance(ClientRequest clientRequest, Channel channel) {
        long lengthLong = clientRequest.getLengthLong();
        RequestEntityProcessing entityProcessing = (RequestEntityProcessing)clientRequest.resolveProperty("jersey.config.client.request.entity.processing", RequestEntityProcessing.class);
        if (entityProcessing == null && lengthLong == -1L || entityProcessing == RequestEntityProcessing.CHUNKED) {
            return new DirectEntityWriter(channel, Type.CHUNKED);
        }
        if (lengthLong != -1L) {
            return new DirectEntityWriter(channel, Type.PRESET);
        }
        return new DelayedEntityWriter(channel, Type.DELAYED);
    }

    public static class DirectEntityWriter
    implements NettyEntityWriter {
        private final Channel channel;
        private final JerseyChunkedInput stream;
        private final Type type;

        public DirectEntityWriter(Channel channel, Type type) {
            this.channel = channel;
            this.stream = new JerseyChunkedInput(channel);
            this.type = type;
        }

        @Override
        public void write(Object object) {
            this.channel.write(object);
        }

        @Override
        public void writeAndFlush(Object object) {
            this.channel.writeAndFlush(object);
        }

        @Override
        public void flush() {
            this.channel.flush();
        }

        @Override
        public ChunkedInput getChunkedInput() {
            return this.stream;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.stream;
        }

        @Override
        public long getLength() {
            return this.stream.progress();
        }

        @Override
        public Type getType() {
            return this.type;
        }
    }

    public static enum Type {
        CHUNKED,
        PRESET,
        DELAYED;

    }

    public static class DelayedEntityWriter
    implements NettyEntityWriter {
        private final List<Runnable> delayedOps;
        private final DirectEntityWriter writer;
        private final DelayedOutputStream outputStream;
        private boolean flushed = false;
        private boolean closed = false;

        public DelayedEntityWriter(Channel channel, Type type) {
            this.writer = new DirectEntityWriter(channel, type);
            this.delayedOps = new LinkedList<Runnable>();
            this.outputStream = new DelayedOutputStream();
        }

        @Override
        public void write(Object object) {
            if (!this.flushed) {
                this.delayedOps.add(() -> this.writer.write(object));
            } else {
                this.writer.write(object);
            }
        }

        @Override
        public void writeAndFlush(Object object) {
            if (!this.flushed) {
                this.delayedOps.add(() -> this.writer.writeAndFlush(object));
            } else {
                this.writer.writeAndFlush(object);
            }
        }

        @Override
        public void flush() throws IOException {
            this._flush();
            if (!this.closed) {
                this.closed = true;
                this.writer.getOutputStream().close();
            }
            this.writer.flush();
        }

        private void _flush() throws IOException {
            if (!this.flushed) {
                this.flushed = true;
                for (Runnable runnable : this.delayedOps) {
                    runnable.run();
                }
                if (this.outputStream.b != null) {
                    this.writer.getOutputStream().write(this.outputStream.b, this.outputStream.off, this.outputStream.len);
                }
            }
        }

        @Override
        public ChunkedInput getChunkedInput() {
            return this.writer.getChunkedInput();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        @Override
        public long getLength() {
            return this.outputStream.len - this.outputStream.off;
        }

        @Override
        public Type getType() {
            return this.writer.getType();
        }

        private class DelayedOutputStream
        extends OutputStream {
            private byte[] b;
            private int off;
            private int len;

            private DelayedOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)(b & 0xFF)}, 0, 1);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (!DelayedEntityWriter.this.flushed && this.b == null) {
                    this.b = b;
                    this.off = off;
                    this.len = len;
                } else {
                    DelayedEntityWriter.this._flush();
                    DelayedEntityWriter.this.writer.getOutputStream().write(b, off, len);
                }
            }
        }
    }
}

