/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.concurrent.GenericFutureListener;
import jakarta.inject.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class JerseyChunkedInput
extends OutputStream
implements ChunkedInput<ByteBuf>,
ChannelFutureListener {
    private static final ByteBuffer VOID = ByteBuffer.allocate(0);
    private static final int CAPACITY = Integer.getInteger("jersey.ci.capacity", 8);
    private static final int WRITE_TIMEOUT = Integer.getInteger("jersey.ci.read.timeout", 10000);
    private static final int READ_TIMEOUT = Integer.getInteger("jersey.ci.write.timeout", 10000);
    private final LinkedBlockingDeque<ByteBuffer> queue = new LinkedBlockingDeque(CAPACITY);
    private final Channel ctx;
    private final ChannelFuture future;
    private volatile boolean open = true;
    private volatile long offset = 0L;

    public JerseyChunkedInput(Channel ctx) {
        this.ctx = ctx;
        this.future = ctx.closeFuture();
        this.future.addListener((GenericFutureListener)this);
    }

    public boolean isEndOfInput() throws Exception {
        if (!this.open) {
            return true;
        }
        ByteBuffer peek = this.queue.peek();
        if (peek != null && peek == VOID) {
            this.queue.remove();
            this.open = false;
            this.removeCloseListener();
            return true;
        }
        return false;
    }

    public void operationComplete(ChannelFuture f) throws Exception {
        this.open = false;
        this.queue.clear();
        this.close();
        this.removeCloseListener();
    }

    private void removeCloseListener() {
        if (this.future != null) {
            this.future.removeListener((GenericFutureListener)this);
        }
    }

    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
        try {
            return this.readChunk0(allocator);
        }
        catch (Exception e) {
            this.closeOnThrowable();
            throw e;
        }
    }

    private ByteBuf readChunk0(ByteBufAllocator allocator) throws Exception {
        if (!this.open) {
            return null;
        }
        ByteBuffer top = this.queue.poll(READ_TIMEOUT, TimeUnit.MILLISECONDS);
        if (top == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (top == VOID) {
            this.open = false;
            return null;
        }
        int topRemaining = top.remaining();
        ByteBuf buffer = allocator.buffer(topRemaining);
        buffer.setBytes(0, top);
        buffer.setIndex(0, topRemaining);
        if (top.remaining() > 0) {
            this.queue.addFirst(top);
        }
        this.offset += (long)topRemaining;
        return buffer;
    }

    public long length() {
        return -1L;
    }

    public long progress() {
        return this.offset;
    }

    private void closeOnThrowable() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        if (this.queue.size() == CAPACITY) {
            boolean offer = false;
            try {
                offer = this.queue.offer(VOID, WRITE_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!offer) {
                this.queue.removeLast();
                this.queue.add(VOID);
            }
        } else {
            this.queue.add(VOID);
        }
        this.ctx.flush();
    }

    @Override
    public void write(final int b) throws IOException {
        this.write(new Provider<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.wrap(new byte[]{(byte)b});
            }
        });
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        final byte[] bytes = new byte[len];
        System.arraycopy(b, off, bytes, 0, len);
        this.write(new Provider<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.wrap(bytes);
            }
        });
    }

    @Override
    public void flush() throws IOException {
        this.ctx.flush();
    }

    private void write(Provider<ByteBuffer> bufferSupplier) throws IOException {
        this.checkClosed();
        try {
            boolean queued = this.queue.offer((ByteBuffer)bufferSupplier.get(), WRITE_TIMEOUT, TimeUnit.MILLISECONDS);
            if (!queued) {
                this.closeOnThrowable();
                throw new IOException("Buffer overflow.");
            }
        }
        catch (InterruptedException e) {
            this.closeOnThrowable();
            throw new IOException(e);
        }
    }

    private void checkClosed() throws IOException {
        if (!this.open) {
            throw new IOException("Stream already closed.");
        }
    }
}

