/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.netty.connector.JerseyClientHandler;

public class NettyHttpRedirectController {
    public boolean prepareRedirect(ClientRequest request, ClientResponse response) {
        Boolean keepMethod = (Boolean)request.resolveProperty("jersey.config.client.redirect.preserve.method", (Object)Boolean.TRUE);
        if (Boolean.FALSE.equals(keepMethod) && request.getMethod().equals("POST")) {
            switch (response.getStatus()) {
                case 301: 
                case 302: {
                    this.removeContentHeaders((MultivaluedMap<String, Object>)request.getHeaders());
                    request.setMethod("GET");
                    request.setEntity(null);
                }
            }
        }
        this.restrictRequestHeaders(request, response);
        return true;
    }

    protected void restrictRequestHeaders(ClientRequest request, ClientResponse response) {
        MultivaluedMap headers = request.getHeaders();
        Iterator it = headers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            if (!JerseyClientHandler.ProxyHeaders.INSTANCE.test((String)entry.getKey())) continue;
            it.remove();
        }
        headers.remove((Object)"If-Match");
        headers.remove((Object)"If-None-Match");
        headers.remove((Object)"If-Modified-Since");
        headers.remove((Object)"If-Unmodified-Since");
        headers.remove((Object)"Authorization");
        headers.remove((Object)"Referer");
        headers.remove((Object)"Cookie");
    }

    private void removeContentHeaders(MultivaluedMap<String, Object> headers) {
        Iterator it = headers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String lowName = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
            if (!lowName.startsWith("content-")) continue;
            it.remove();
        }
        headers.remove((Object)"Last-Modified");
        headers.remove((Object)"Transfer-Encoding");
    }
}

