/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly2;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.jersey.message.internal.Requests;
import org.glassfish.jersey.server.Application;
import org.glassfish.jersey.server.ContainerResponseWriter;

public final class GrizzlyHttpContainer
extends HttpHandler {
    private Application application;

    GrizzlyHttpContainer(Application application) {
        this.application = application;
    }

    public void service(Request request, Response response) {
        this.application.apply(this.toJaxrsRequest(request), (ContainerResponseWriter)new Writer(response));
        response.finish();
    }

    private URI getBaseUri(Request request) {
        try {
            return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), this.getBasePath(request), null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getBasePath(Request request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.length() == 0) {
            return "/";
        }
        if (contextPath.charAt(contextPath.length() - 1) != '/') {
            return contextPath + "/";
        }
        return contextPath;
    }

    private javax.ws.rs.core.Request toJaxrsRequest(Request grizzlyRequest) {
        URI baseUri = this.getBaseUri(grizzlyRequest);
        String originalURI = UriBuilder.fromPath((String)grizzlyRequest.getRequest().getRequestURIRef().getOriginalRequestURIBC().toString(Charsets.DEFAULT_CHARSET)).build(new Object[0]).toString();
        String queryString = grizzlyRequest.getQueryString();
        if (queryString != null) {
            originalURI = originalURI + "?" + queryString;
        }
        URI requestUri = baseUri.resolve(originalURI);
        String method = grizzlyRequest.getMethod().getMethodString();
        Request.RequestBuilder rb = Requests.from((URI)baseUri, (URI)requestUri, (String)method).entity((Object)grizzlyRequest.getInputStream());
        for (String name : grizzlyRequest.getHeaderNames()) {
            for (String value : grizzlyRequest.getHeaders(name)) {
                rb.header(name, (Object)value);
            }
        }
        return rb.build();
    }

    private static final class Writer
    implements ContainerResponseWriter {
        final Response grizzlyResponse;

        Writer(Response response) {
            this.grizzlyResponse = response;
        }

        public void finish() throws IOException {
        }

        public OutputStream writeStatusAndHeaders(long contentLength, javax.ws.rs.core.Response jaxrsResponse) throws IOException {
            this.grizzlyResponse.setStatus(jaxrsResponse.getStatus());
            for (Map.Entry e : jaxrsResponse.getHeaders().asMap().entrySet()) {
                for (String value : (List)e.getValue()) {
                    this.grizzlyResponse.addHeader((String)e.getKey(), value);
                }
            }
            String contentType = jaxrsResponse.getHeaders().getHeader("Content-Type");
            if (contentLength > 0L && contentType != null) {
                this.grizzlyResponse.setContentType(contentType);
            }
            return this.grizzlyResponse.getOutputStream();
        }
    }
}

