/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly2;

import java.io.IOException;
import java.net.URI;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.server.Application;
import org.glassfish.jersey.server.ContainerFactory;

public class GrizzlyHttpServerFactory {
    public static HttpServer createHttpServer(URI uri, Application application) throws ProcessingException {
        return GrizzlyHttpServerFactory._createHttpServer(uri, (HttpHandler)ContainerFactory.createContainer(HttpHandler.class, (Application)application));
    }

    public static HttpServer createHttpServer(URI uri) throws ProcessingException {
        return GrizzlyHttpServerFactory._createHttpServer(uri, null);
    }

    private static HttpServer _createHttpServer(URI u, HttpHandler handler) throws ProcessingException {
        String host = u.getHost() == null ? "0.0.0.0" : u.getHost();
        int port = u.getPort() == -1 ? 80 : u.getPort();
        HttpServer server = new HttpServer();
        NetworkListener listener = new NetworkListener("grizzly", host, port);
        server.addListener(listener);
        ServerConfiguration config = server.getServerConfiguration();
        if (handler != null) {
            config.addHttpHandler(handler, new String[]{u.getPath()});
        }
        try {
            server.start();
        }
        catch (IOException ex) {
            throw new ProcessingException("IOException thrown when trying to start grizzly server", (Throwable)ex);
        }
        return server;
    }
}

