/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly2;

import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.TimeoutHandler;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.message.internal.Requests;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerRequestContext;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.spi.JerseyContainerRequestContext;

public final class GrizzlyHttpContainer
extends HttpHandler
implements Container {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(GrizzlyHttpContainer.class.getName()), Level.FINEST);
    private static final CompletionHandler<org.glassfish.grizzly.http.server.Response> EMPTY_COMPLETION_HANDLER = new CompletionHandler<org.glassfish.grizzly.http.server.Response>(){

        public void cancelled() {
        }

        public void failed(Throwable throwable) {
        }

        public void completed(org.glassfish.grizzly.http.server.Response result) {
        }

        public void updated(org.glassfish.grizzly.http.server.Response result) {
        }
    };
    private final ApplicationHandler appHandler;

    GrizzlyHttpContainer(ApplicationHandler application) {
        this.appHandler = application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(org.glassfish.grizzly.http.server.Request request, org.glassfish.grizzly.http.server.Response response) {
        ResponseWriter responseWriter = new ResponseWriter(response);
        try {
            logger.debugLog("GrizzlyHttpContaner.service(...) started", new Object[0]);
            JerseyContainerRequestContext conteinerContext = new JerseyContainerRequestContext(this.toJaxrsRequest(request), (ContainerResponseWriter)responseWriter, this.getSecurityContext(request), null);
            this.appHandler.apply((ContainerRequestContext)conteinerContext);
        }
        finally {
            logger.debugLog("GrizzlyHttpContaner.service(...) finished", new Object[0]);
        }
    }

    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    public void reload() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reload(ResourceConfig configuration) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private SecurityContext getSecurityContext(final org.glassfish.grizzly.http.server.Request request) {
        return new SecurityContext(){

            public boolean isUserInRole(String role) {
                return false;
            }

            public boolean isSecure() {
                return request.isSecure();
            }

            public Principal getUserPrincipal() {
                return request.getUserPrincipal();
            }

            public String getAuthenticationScheme() {
                return request.getAuthType();
            }
        };
    }

    private URI getBaseUri(org.glassfish.grizzly.http.server.Request request) {
        try {
            return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), this.getBasePath(request), null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getBasePath(org.glassfish.grizzly.http.server.Request request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.length() == 0) {
            return "/";
        }
        if (contextPath.charAt(contextPath.length() - 1) != '/') {
            return contextPath + "/";
        }
        return contextPath;
    }

    private Request toJaxrsRequest(org.glassfish.grizzly.http.server.Request grizzlyRequest) {
        URI baseUri = this.getBaseUri(grizzlyRequest);
        String originalURI = UriBuilder.fromPath((String)grizzlyRequest.getRequest().getRequestURIRef().getOriginalRequestURIBC().toString(Charsets.DEFAULT_CHARSET)).build(new Object[0]).toString();
        String queryString = grizzlyRequest.getQueryString();
        if (queryString != null) {
            originalURI = originalURI + "?" + queryString;
        }
        URI requestUri = baseUri.resolve(originalURI);
        String method = grizzlyRequest.getMethod().getMethodString();
        Request.RequestBuilder rb = Requests.from((URI)baseUri, (URI)requestUri, (String)method).entity((Object)grizzlyRequest.getInputStream());
        for (String name : grizzlyRequest.getHeaderNames()) {
            for (String value : grizzlyRequest.getHeaders(name)) {
                rb.header(name, (Object)value);
            }
        }
        return rb.build();
    }

    private static final class ResponseWriter
    implements ContainerResponseWriter {
        private final String name;
        private final org.glassfish.grizzly.http.server.Response grizzlyResponse;

        ResponseWriter(org.glassfish.grizzly.http.server.Response response) {
            this.grizzlyResponse = response;
            if (logger.isDebugLoggable()) {
                this.name = "ResponseWriter {id=" + UUID.randomUUID().toString() + ", grizzlyResponse=" + this.grizzlyResponse.hashCode() + '}';
                logger.debugLog("{0} - init", new Object[]{this.name});
            } else {
                this.name = "ResponseWriter";
            }
        }

        public String toString() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() {
            try {
                if (this.grizzlyResponse.isSuspended()) {
                    this.grizzlyResponse.resume();
                }
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - commit() called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - commit() called", new Object[]{this.name});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            try {
                this.grizzlyResponse.cancel();
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - cancel() called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - cancel() called", new Object[]{this.name});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspend(long timeOut, TimeUnit timeUnit, final ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            try {
                this.grizzlyResponse.suspend(timeOut, timeUnit, EMPTY_COMPLETION_HANDLER, new TimeoutHandler(){

                    public boolean onTimeout(org.glassfish.grizzly.http.server.Response response) {
                        timeoutHandler.onTimeout((ContainerResponseWriter)ResponseWriter.this);
                        return false;
                    }
                });
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - suspend(...) called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - suspend(...) called", new Object[]{this.name});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            try {
                this.grizzlyResponse.getSuspendContext().setTimeout(timeOut, timeUnit);
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - setSuspendTimeout(...) called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - setSuspendTimeout(...) called", new Object[]{this.name});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputStream writeResponseStatusAndHeaders(long contentLength, Response jaxrsResponse) throws ContainerException {
            OutputStream outputStream;
            try {
                this.grizzlyResponse.setStatus(jaxrsResponse.getStatus());
                for (Map.Entry e : jaxrsResponse.getHeaders().asMap().entrySet()) {
                    for (String value : (List)e.getValue()) {
                        this.grizzlyResponse.addHeader((String)e.getKey(), value);
                    }
                }
                String contentType = jaxrsResponse.getHeaders().getHeader("Content-Type");
                if (contentLength > 0L && contentType != null) {
                    this.grizzlyResponse.setContentType(contentType);
                }
                outputStream = this.grizzlyResponse.getOutputStream();
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - writeResponseStatusAndHeaders() called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - writeResponseStatusAndHeaders() called", new Object[]{this.name});
            return outputStream;
        }
    }
}

