/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly2;

import java.io.IOException;
import java.net.URI;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.jersey.grizzly2.GrizzlyHttpContainer;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class GrizzlyHttpServerFactory {
    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration) throws ProcessingException {
        return GrizzlyHttpServerFactory.createHttpServer(uri, (GrizzlyHttpContainer)((Object)ContainerFactory.createContainer(GrizzlyHttpContainer.class, (ResourceConfig)configuration)));
    }

    public static HttpServer createHttpServer(URI uri, ApplicationHandler appHandler) throws ProcessingException {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer(appHandler));
    }

    public static HttpServer createHttpServer(URI uri) throws ProcessingException {
        return GrizzlyHttpServerFactory.createHttpServer(uri, (GrizzlyHttpContainer)null);
    }

    private static HttpServer createHttpServer(URI u, GrizzlyHttpContainer handler) throws ProcessingException {
        String host = u.getHost() == null ? "0.0.0.0" : u.getHost();
        int port = u.getPort() == -1 ? 80 : u.getPort();
        HttpServer server = new HttpServer();
        NetworkListener listener = new NetworkListener("grizzly", host, port);
        server.addListener(listener);
        ServerConfiguration config = server.getServerConfiguration();
        if (handler != null) {
            config.addHttpHandler((HttpHandler)handler, new String[]{u.getPath()});
        }
        try {
            server.start();
        }
        catch (IOException ex) {
            throw new ProcessingException("IOException thrown when trying to start grizzly server", (Throwable)ex);
        }
        return server;
    }

    private GrizzlyHttpServerFactory() {
    }
}

