/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly2.httpserver;

import java.io.IOException;
import java.net.URI;
import javax.ws.rs.core.Application;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpContainer;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class GrizzlyHttpServerFactory {
    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration) throws ProcessingException {
        return GrizzlyHttpServerFactory.createHttpServer(uri, (HttpHandler)ContainerFactory.createContainer(GrizzlyHttpContainer.class, (Application)configuration), false, null);
    }

    public static HttpServer createHttpServer(URI uri, ApplicationHandler appHandler) throws ProcessingException {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer(appHandler), false, null);
    }

    public static HttpServer createHttpServer(URI uri) throws ProcessingException {
        return GrizzlyHttpServerFactory.createHttpServer(uri, (HttpHandler)null, false, null);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, boolean secure, SSLEngineConfigurator sslEngineConfigurator) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, (HttpHandler)ContainerFactory.createContainer(GrizzlyHttpContainer.class, (Application)configuration), secure, sslEngineConfigurator);
    }

    public static HttpServer createHttpServer(URI uri, ApplicationHandler appHandler, boolean secure, SSLEngineConfigurator sslEngineConfigurator) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer(appHandler), secure, sslEngineConfigurator);
    }

    private static HttpServer createHttpServer(URI uri, HttpHandler handler, boolean secure, SSLEngineConfigurator sslEngineConfigurator) throws ProcessingException {
        String host = uri.getHost() == null ? "0.0.0.0" : uri.getHost();
        int port = uri.getPort() == -1 ? 80 : uri.getPort();
        HttpServer server = new HttpServer();
        NetworkListener listener = new NetworkListener("grizzly", host, port);
        listener.setSecure(secure);
        if (sslEngineConfigurator != null) {
            listener.setSSLEngineConfig(sslEngineConfigurator);
        }
        server.addListener(listener);
        ServerConfiguration config = server.getServerConfiguration();
        if (handler != null) {
            config.addHttpHandler(handler, new String[]{uri.getPath()});
        }
        config.setPassTraceRequest(true);
        try {
            server.start();
        }
        catch (IOException ex) {
            throw new ProcessingException("IOException thrown when trying to start grizzly server", (Throwable)ex);
        }
        return server;
    }

    private GrizzlyHttpServerFactory() {
    }
}

